/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.stcore;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum STBinaryOperator implements Enumerator
{
    RANGE(0, "Range", ".."),
    OR(1, "OR", "OR"),
    XOR(2, "XOR", "XOR"),
    AND(3, "AND", "AND"),
    AMPERSAND(4, "AMPERSAND", "&"),
    EQ(5, "EQ", "="),
    NE(6, "NE", "<>"),
    LT(7, "LT", "<"),
    LE(8, "LE", "<="),
    GT(9, "GT", ">"),
    GE(10, "GE", ">="),
    ADD(11, "ADD", "+"),
    SUB(12, "SUB", "-"),
    MUL(13, "MUL", "*"),
    DIV(14, "DIV", "/"),
    MOD(15, "MOD", "MOD"),
    POWER(16, "POWER", "**");

    public static final int RANGE_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int XOR_VALUE = 2;
    public static final int AND_VALUE = 3;
    public static final int AMPERSAND_VALUE = 4;
    public static final int EQ_VALUE = 5;
    public static final int NE_VALUE = 6;
    public static final int LT_VALUE = 7;
    public static final int LE_VALUE = 8;
    public static final int GT_VALUE = 9;
    public static final int GE_VALUE = 10;
    public static final int ADD_VALUE = 11;
    public static final int SUB_VALUE = 12;
    public static final int MUL_VALUE = 13;
    public static final int DIV_VALUE = 14;
    public static final int MOD_VALUE = 15;
    public static final int POWER_VALUE = 16;
    private static final STBinaryOperator[] VALUES_ARRAY;
    public static final List<STBinaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new STBinaryOperator[]{RANGE, OR, XOR, AND, AMPERSAND, EQ, NE, LT, LE, GT, GE, ADD, SUB, MUL, DIV, MOD, POWER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static STBinaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            STBinaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static STBinaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            STBinaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static STBinaryOperator get(int value) {
        switch (value) {
            case 0: {
                return RANGE;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return XOR;
            }
            case 3: {
                return AND;
            }
            case 4: {
                return AMPERSAND;
            }
            case 5: {
                return EQ;
            }
            case 6: {
                return NE;
            }
            case 7: {
                return LT;
            }
            case 8: {
                return LE;
            }
            case 9: {
                return GT;
            }
            case 10: {
                return GE;
            }
            case 11: {
                return ADD;
            }
            case 12: {
                return SUB;
            }
            case 13: {
                return MUL;
            }
            case 14: {
                return DIV;
            }
            case 15: {
                return MOD;
            }
            case 16: {
                return POWER;
            }
        }
        return null;
    }

    private STBinaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

