/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.ui.builder;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;
import org.eclipse.fordiac.ide.structuredtextalgorithm.resource.STAlgorithmResource;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextcore.ui.validation.ModelIssueListValidationMesageAcceptor;
import org.eclipse.fordiac.ide.structuredtextcore.ui.validation.ValidationUtil;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreImportValidator;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreTypeUsageCollector;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreVariableUsageValidator;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.IssueSeveritiesProvider;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class STAlgorithmInitialValueBuilderParticipant
implements IXtextBuilderParticipant {
    @Inject
    private MarkerCreator markerCreator;
    @Inject
    private Provider<STCoreTypeUsageCollector> typeUsageCollectorProvider;
    @Inject
    private STCoreImportValidator importValidator;
    @Inject
    private IssueSeveritiesProvider severitiesProvider;

    public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        List<IResourceDescription.Delta> deltas = this.getRelevantDeltas(context);
        for (IResourceDescription.Delta delta : deltas) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (delta.getOld() != null) {
                this.doClean(delta);
            }
            if (delta.getNew() == null) continue;
            this.doBuild(delta, context, monitor);
        }
    }

    protected void doBuild(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        try {
            IFile file = STAlgorithmInitialValueBuilderParticipant.getFile(delta.getNew().getURI());
            STCoreTypeUsageCollector typeUsageCollector = (STCoreTypeUsageCollector)this.typeUsageCollectorProvider.get();
            boolean ignoreWarnings = ValidationUtil.isIgnoreWarnings((IFile)file);
            Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
            ModelIssueListValidationMesageAcceptor acceptor = new ModelIssueListValidationMesageAcceptor();
            STCoreVariableUsageValidator variableUsageValidator = new STCoreVariableUsageValidator((ValidationMessageAcceptor)acceptor, this.severitiesProvider.getIssueSeverities(resource));
            STAlgorithmInitialValueBuilderParticipant.prepare(resource, variableUsageValidator);
            this.validateContents(resource, delta, typeUsageCollector, variableUsageValidator, ignoreWarnings, context, monitor);
            this.validateImports(resource, delta, typeUsageCollector, ignoreWarnings, monitor);
            this.validateUnused(variableUsageValidator, acceptor, delta, ignoreWarnings, monitor);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new CoreException(Status.error((String)("Exception processing build delta " + delta.getUri().toString()), (Throwable)e));
        }
    }

    protected void doClean(IResourceDescription.Delta delta) throws CoreException {
        IFile file = STAlgorithmInitialValueBuilderParticipant.getFile(delta.getOld().getURI());
        if (file != null && file.exists()) {
            file.deleteMarkers("org.eclipse.fordiac.ide.model.initialValue", true, 2);
            file.deleteMarkers("org.eclipse.fordiac.ide.model.typeDeclaration", true, 2);
            file.deleteMarkers("org.eclipse.fordiac.ide.model.conditionExpression", true, 2);
            file.deleteMarkers("org.eclipse.fordiac.ide.model.import", true, 2);
            file.deleteMarkers("org.eclipse.fordiac.ide.model.unused", true, 2);
        }
    }

    protected static void prepare(Resource resource, STCoreVariableUsageValidator variableUsageValidator) {
        for (EObject object : resource.getContents()) {
            if (!(object instanceof BaseFBType)) continue;
            BaseFBType baseFBType = (BaseFBType)object;
            variableUsageValidator.addVariables((ICallable)baseFBType);
            variableUsageValidator.addVariables((List)baseFBType.getInternalVars());
            variableUsageValidator.addVariables((List)baseFBType.getInternalConstVars(), EnumSet.of(STCoreVariableUsageValidator.VariableState.UNUSED, STCoreVariableUsageValidator.VariableState.UNREAD));
            variableUsageValidator.addVariables((List)baseFBType.getInternalFbs(), EnumSet.of(STCoreVariableUsageValidator.VariableState.UNUSED));
        }
    }

    protected void validateContents(Resource resource, IResourceDescription.Delta delta, STCoreTypeUsageCollector typeUsageCollector, STCoreVariableUsageValidator variableUsageValidator, boolean ignoreWarnings, IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        TreeIterator allContents = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (allContents.hasNext()) {
            EObject eObject;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Objects.requireNonNull((EObject)allContents.next());
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SystemConfiguration.class, Attribute.class, VarDeclaration.class, ECTransition.class, STSource.class}, (Object)eObject, 0)) {
                case 0: {
                    SystemConfiguration configuration = (SystemConfiguration)eObject;
                    allContents.prune();
                    break;
                }
                case 1: {
                    Attribute attribute = (Attribute)eObject;
                    STAlgorithmInitialValueBuilderParticipant.validateType(attribute, delta, typeUsageCollector, ignoreWarnings, context, monitor);
                    this.validateValue(attribute, delta, typeUsageCollector, variableUsageValidator, ignoreWarnings, context, monitor);
                    break;
                }
                case 2: {
                    VarDeclaration varDeclaration = (VarDeclaration)eObject;
                    this.validateType(varDeclaration, delta, typeUsageCollector, variableUsageValidator, ignoreWarnings, context, monitor);
                    this.validateValue(varDeclaration, delta, typeUsageCollector, variableUsageValidator, ignoreWarnings, context, monitor);
                    break;
                }
                case 3: {
                    ECTransition transition = (ECTransition)eObject;
                    this.validateConditionExpression(transition, delta, typeUsageCollector, variableUsageValidator, ignoreWarnings, context, monitor);
                    break;
                }
                case 4: {
                    STSource source = (STSource)eObject;
                    typeUsageCollector.collectUsedTypes((EObject)source);
                    variableUsageValidator.addReferences((EObject)source);
                    allContents.prune();
                    break;
                }
            }
        }
    }

    protected void validateType(VarDeclaration varDeclaration, IResourceDescription.Delta delta, STCoreTypeUsageCollector typeUsageCollector, STCoreVariableUsageValidator variableUsageValidator, boolean ignoreWarnings, IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (ValidationUtil.isContainedInTypedInstance((IInterfaceElement)varDeclaration)) {
            return;
        }
        ArrayList<Issue> issues = new ArrayList<Issue>();
        if (varDeclaration.getType() instanceof AnyType) {
            if (varDeclaration.isArray()) {
                STAlgorithmInitialValueBuilderParticipant.validate((EObject)varDeclaration.getArraySize(), delta, typeUsageCollector, variableUsageValidator, issues, context);
                issues.replaceAll(issue -> ValidationUtil.convertToModelIssue((Issue)issue, (EObject)varDeclaration.getArraySize()));
            } else {
                typeUsageCollector.addUsedType((LibraryElement)varDeclaration.getType());
            }
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!issues.isEmpty() && (file = STAlgorithmInitialValueBuilderParticipant.getFile(delta.getUri())) != null && file.exists()) {
            this.createMarkers(file, "org.eclipse.fordiac.ide.model.typeDeclaration", issues, ignoreWarnings, monitor);
        }
    }

    protected void validateValue(VarDeclaration varDeclaration, IResourceDescription.Delta delta, STCoreTypeUsageCollector typeUsageCollector, STCoreVariableUsageValidator variableUsageValidator, boolean ignoreWarnings, IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        IFile file;
        String value = STAlgorithmInitialValueBuilderParticipant.getValue(varDeclaration);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        if (!value.isBlank() && varDeclaration.getType() instanceof AnyType) {
            LibraryElement featureType = STCoreUtil.getFeatureType((INamedElement)varDeclaration);
            try {
                new TypedValueConverter((DataType)featureType, true).toValue(value);
            }
            catch (Exception e) {
                STAlgorithmInitialValueBuilderParticipant.validate((EObject)varDeclaration.getValue(), delta, typeUsageCollector, variableUsageValidator, issues, context);
                issues.replaceAll(issue -> ValidationUtil.convertToModelIssue((Issue)issue, (EObject)varDeclaration.getValue()));
            }
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!issues.isEmpty() && (file = STAlgorithmInitialValueBuilderParticipant.getFile(delta.getUri())) != null && file.exists()) {
            this.createMarkers(file, "org.eclipse.fordiac.ide.model.initialValue", issues, ignoreWarnings, monitor);
        }
    }

    protected static void validateType(Attribute attribute, IResourceDescription.Delta delta, STCoreTypeUsageCollector typeUsageCollector, boolean ignoreWarnings, IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) {
        if (attribute.getAttributeDeclaration() != null) {
            typeUsageCollector.addUsedType((LibraryElement)attribute.getAttributeDeclaration());
        } else if (attribute.getType() instanceof AnyType) {
            typeUsageCollector.addUsedType((LibraryElement)attribute.getType());
        }
    }

    protected void validateValue(Attribute attribute, IResourceDescription.Delta delta, STCoreTypeUsageCollector typeUsageCollector, STCoreVariableUsageValidator variableUsageValidator, boolean ignoreWarnings, IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        IFile file;
        String value = STAlgorithmInitialValueBuilderParticipant.getValue(attribute);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        if (!value.isBlank() && attribute.getType() instanceof AnyType && !InternalAttributeDeclarations.isInternalAttribute((AttributeDeclaration)attribute.getAttributeDeclaration())) {
            DataType featureType = STAlgorithmInitialValueBuilderParticipant.getActualType(attribute);
            try {
                new TypedValueConverter(featureType, attribute.getAttributeDeclaration() != null).toValue(value);
            }
            catch (Exception e) {
                STAlgorithmInitialValueBuilderParticipant.validate((EObject)attribute, delta, typeUsageCollector, variableUsageValidator, issues, context);
                issues.replaceAll(issue -> ValidationUtil.convertToModelIssue((Issue)issue, (EObject)attribute, (EStructuralFeature)LibraryElementPackage.Literals.ATTRIBUTE__VALUE));
            }
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!issues.isEmpty() && (file = STAlgorithmInitialValueBuilderParticipant.getFile(delta.getUri())) != null && file.exists()) {
            this.createMarkers(file, "org.eclipse.fordiac.ide.model.initialValue", issues, ignoreWarnings, monitor);
        }
    }

    protected void validateConditionExpression(ECTransition transition, IResourceDescription.Delta delta, STCoreTypeUsageCollector typeUsageCollector, STCoreVariableUsageValidator variableUsageValidator, boolean ignoreWarnings, IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        IFile file;
        ArrayList<Issue> issues = new ArrayList<Issue>();
        if (VariableOperations.hasConditionExpression((ECTransition)transition)) {
            STAlgorithmInitialValueBuilderParticipant.validate((EObject)transition, delta, typeUsageCollector, variableUsageValidator, issues, context);
            issues.replaceAll(issue -> ValidationUtil.convertToModelIssue((Issue)issue, (EObject)transition, (EStructuralFeature)LibraryElementPackage.Literals.EC_TRANSITION__CONDITION_EXPRESSION));
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!issues.isEmpty() && (file = STAlgorithmInitialValueBuilderParticipant.getFile(delta.getUri())) != null && file.exists()) {
            this.createMarkers(file, "org.eclipse.fordiac.ide.model.conditionExpression", issues, ignoreWarnings, monitor);
        }
    }

    protected void validateImports(Resource resource, IResourceDescription.Delta delta, STCoreTypeUsageCollector typeUsageCollector, boolean ignoreWarnings, IProgressMonitor monitor) throws CoreException {
        for (EObject object : resource.getContents()) {
            if (!(object instanceof LibraryElement)) continue;
            LibraryElement libraryElement = (LibraryElement)object;
            this.validateImports(libraryElement, delta, typeUsageCollector.getUsedTypes(), ignoreWarnings, monitor);
        }
    }

    protected void validateImports(LibraryElement element, IResourceDescription.Delta delta, Set<QualifiedName> usedTypes, boolean ignoreWarnings, IProgressMonitor monitor) throws CoreException {
        IFile file;
        List imports = ImportHelper.getImports((LibraryElement)element);
        if (imports.isEmpty()) {
            return;
        }
        String packageName = PackageNameHelper.getPackageName((LibraryElement)element);
        ModelIssueListValidationMesageAcceptor acceptor = new ModelIssueListValidationMesageAcceptor();
        this.importValidator.validateImports(packageName, imports, usedTypes, (ValidationMessageAcceptor)acceptor);
        if (!acceptor.isEmpty() && (file = STAlgorithmInitialValueBuilderParticipant.getFile(delta.getUri())) != null && file.exists()) {
            this.createMarkers(file, "org.eclipse.fordiac.ide.model.import", acceptor.getIssues(), ignoreWarnings, monitor);
        }
    }

    protected void validateUnused(STCoreVariableUsageValidator variableUsageValidator, ModelIssueListValidationMesageAcceptor acceptor, IResourceDescription.Delta delta, boolean ignoreWarnings, IProgressMonitor monitor) throws CoreException {
        IFile file;
        variableUsageValidator.validateUnused();
        if (!acceptor.isEmpty() && (file = STAlgorithmInitialValueBuilderParticipant.getFile(delta.getUri())) != null && file.exists()) {
            this.createMarkers(file, "org.eclipse.fordiac.ide.model.unused", acceptor.getIssues(), ignoreWarnings, monitor);
        }
    }

    protected static void validate(EObject element, IResourceDescription.Delta delta, STCoreTypeUsageCollector typeUsageCollector, STCoreVariableUsageValidator variableUsageValidator, List<Issue> issues, IXtextBuilderParticipant.IBuildContext context) {
        String fragment = LibraryElementXtextResource.toExternalFragment((String)element.eResource().getURIFragment(element));
        URI uri = delta.getUri().appendQuery(fragment);
        Resource resource = context.getResourceSet().getResource(uri, true);
        if (resource instanceof XtextResource) {
            XtextResource xtextResource = (XtextResource)resource;
            EcoreUtil.resolveAll((Resource)xtextResource);
            IResourceValidator validator = xtextResource.getResourceServiceProvider().getResourceValidator();
            issues.addAll(validator.validate((Resource)xtextResource, CheckMode.FAST_ONLY, CancelIndicator.NullImpl));
        }
        if (!resource.getContents().isEmpty()) {
            typeUsageCollector.collectUsedTypes((EObject)resource.getContents().getFirst());
            variableUsageValidator.addReferences((EObject)resource.getContents().getFirst());
        }
        resource.unload();
        context.getResourceSet().getResources().remove((Object)resource);
    }

    protected void createMarkers(IFile file, String type, List<Issue> issues, boolean ignoreWarnings, IProgressMonitor monitor) throws CoreException {
        for (Issue issue : issues) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!ValidationUtil.shouldProcess((Issue)issue, (boolean)ignoreWarnings)) continue;
            this.markerCreator.createMarker(issue, (IResource)file, type);
        }
    }

    protected static String getValue(VarDeclaration varDeclaration) {
        if (varDeclaration.getValue() != null && varDeclaration.getValue().getValue() != null) {
            return varDeclaration.getValue().getValue();
        }
        return "";
    }

    protected static String getValue(Attribute attribute) {
        if (attribute.getValue() != null) {
            return attribute.getValue();
        }
        return "";
    }

    protected static DataType getActualType(Attribute attribute) {
        DataType dataType = attribute.getType();
        if (dataType instanceof DirectlyDerivedType) {
            DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)dataType;
            return directlyDerivedType.getBaseType();
        }
        return attribute.getType();
    }

    protected List<IResourceDescription.Delta> getRelevantDeltas(IXtextBuilderParticipant.IBuildContext context) {
        return context.getDeltas().stream().filter(this::isRelevantDelta).toList();
    }

    protected boolean isRelevantDelta(IResourceDescription.Delta delta) {
        return STAlgorithmResource.isValidUri((URI)delta.getUri()) && !delta.getUri().hasQuery();
    }

    protected static IFile getFile(URI uri) {
        if (uri.isPlatformResource()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return null;
    }
}

