/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.format;

import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.eclipse.tracecompass.common.core.tests.format.FormatTestBase;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataSizeFormatTest
extends FormatTestBase {
    private static final @NonNull Format FORMAT = DataSizeWithUnitFormat.getInstance();

    public DataSizeFormatTest(@Nullable Number numValue, @NonNull String stringValue, @Nullable Number parseValue, int parseIndex) {
        super(numValue, stringValue, parseValue, parseIndex);
    }

    protected static Collection<Object[]> getCommonParameters() {
        return Arrays.asList({0, "0 B", 0L, -1}, {3, "3 B", 3L, -1}, {975, "975 B", 975L, -1}, {1024, "1 KB", 1024L, -1}, {0x100000, "1 MB", 0x100000L, -1}, {0x40000000, "1 GB", 0x40000000L, -1}, {0x10000000000L, "1 TB", 0x10000000000L, -1}, {4096, "4 KB", 4096L, -1}, {-4096, "-4 KB", -4096L, -1}, {4096L, "4 KB", 4096L, -1}, {4096.0, "4 KB", 4096L, -1}, {12345678, "11.774 MB", 1.2345933824E7, -1}, {Integer.MAX_VALUE, "2 GB", 0x80000000L, -1}, {Integer.MIN_VALUE, "-2 GB", Integer.MIN_VALUE, -1}, {Long.MAX_VALUE, "8388608 TB", 9.223372036854776E18, -1}, {9.8765432123456E7, "94.19 MB", 9.876537344E7, -1}, {-9.8765432123456E7, "-94.19 MB", -9.876537344E7, -1}, {555555555555L, "517.401 GB", 5.55555093479424E11, -1}, {555555555555555L, "505.275 TB", 5.555557377245184E14, -1});
    }

    @Parameterized.Parameters(name="{index}: {0} - {1}")
    public static Iterable<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>(DataSizeFormatTest.getCommonParameters());
        Object[][] objectArrayArray = new Object[5][];
        Object[] objectArray = new Object[4];
        objectArray[1] = "1234 TPotato";
        objectArray[2] = 1234L;
        objectArray[3] = 4;
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[4];
        objectArray2[1] = ".0001 MB";
        objectArray2[2] = 104.8576;
        objectArray2[3] = -1;
        objectArrayArray[1] = objectArray2;
        Object[] objectArray3 = new Object[4];
        objectArray3[1] = "1KB";
        objectArray3[2] = 1024L;
        objectArray3[3] = -1;
        objectArrayArray[2] = objectArray3;
        Object[] objectArray4 = new Object[4];
        objectArray4[1] = "1KB   ";
        objectArray4[2] = 1024L;
        objectArray4[3] = 3;
        objectArrayArray[3] = objectArray4;
        Object[] objectArray5 = new Object[4];
        objectArray5[1] = "1KB  potato";
        objectArray5[2] = 1024L;
        objectArray5[3] = 3;
        objectArrayArray[4] = objectArray5;
        List newParameters = Arrays.asList(objectArrayArray);
        parameters.addAll(newParameters);
        return parameters;
    }

    @Override
    protected Format getFormatter() {
        return FORMAT;
    }
}

