/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import com.google.common.collect.ImmutableList;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.io.ResourceUtil;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class XmlUtilsWithTraceTest {
    private static final @NonNull String TEST_TRACE_NAME = "testTrace4.xml";
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    private static final @NonNull String ANALYSIS_ID = "xml.core.tests.simple.pattern";
    private static IProject sfProject;

    @BeforeClass
    public static void startUp() throws CoreException {
        IFolder supplRootFolder;
        IFolder tracesFolder;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        if (!project.exists()) {
            project.create(null);
            if (!project.isOpen()) {
                project.open(null);
            }
            IProjectDescription description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.linuxtools.tmf.project.nature"});
            project.setDescription(description, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        if (!(tracesFolder = project.getFolder("Traces")).exists()) {
            tracesFolder.create(true, true, null);
        }
        if (!(supplRootFolder = project.getFolder(".tracing")).exists()) {
            supplRootFolder.create(true, true, null);
        }
        sfProject = project;
    }

    @AfterClass
    public static void tearDown() throws CoreException {
        if (sfProject != null) {
            sfProject.delete(true, null);
        }
    }

    @Before
    public void setUp() {
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile());
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    @After
    public void cleanUp() {
        XmlUtils.deleteFiles((Iterable)ImmutableList.of((Object)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile().getName()));
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    private ITmfTrace getTrace() throws CoreException {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        String absolutePath = Activator.getAbsolutePath(new Path(TEST_TRACE)).toOSString();
        IStatus status = trace.validate(null, absolutePath);
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        IResource resource = XmlUtilsWithTraceTest.createResource(absolutePath);
        try {
            trace.initTrace(resource, absolutePath, TmfEvent.class);
        }
        catch (TmfTraceException e) {
            trace.dispose();
            Assert.fail((String)e.getMessage());
        }
        TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null);
        trace.traceOpened(signal);
        TmfTraceManager.getInstance().traceOpened(signal);
        return trace;
    }

    private static IResource createResource(String path) throws CoreException {
        Path targetLocation = new Path(path);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        project.refreshLocal(2, null);
        IFolder tracesFolder = project.getFolder("Traces");
        IFile resource = tracesFolder.getFile(TEST_TRACE_NAME);
        ResourceUtil.createSymbolicLink((IResource)resource, (IPath)targetLocation, (boolean)true, null);
        IFolder supplRootFolder = project.getFolder(".tracing");
        IFolder supplFolder = supplRootFolder.getFolder(resource.getProjectRelativePath().removeFirstSegments(1));
        if (!supplFolder.exists()) {
            supplFolder.create(true, true, null);
        }
        resource.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder.getLocation().toOSString());
        return resource;
    }

    private static void runModule(ITmfTrace trace) {
        IAnalysisModule module = trace.getAnalysisModule(ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
    }

    @Test
    public void testDeleteSupplDirWithTraceOpen() throws CoreException {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            XmlUtilsWithTraceTest.runModule(trace);
            String supplPathString = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
            Path path = new Path(supplPathString);
            IPath ssFile = path.addTrailingSeparator().append(ANALYSIS_ID).addFileExtension("ht");
            IPath segFile = path.addTrailingSeparator().append(ANALYSIS_ID).addFileExtension("dat");
            Assert.assertTrue((boolean)ssFile.toFile().exists());
            Assert.assertTrue((boolean)segFile.toFile().exists());
            XmlUtils.deleteSupplementaryResources((String)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile().getName(), null);
            Assert.assertFalse((boolean)ssFile.toFile().exists());
            Assert.assertFalse((boolean)segFile.toFile().exists());
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }

    @Test
    public void testDeleteSupplDirWithTraceClosed() throws CoreException {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            XmlUtilsWithTraceTest.runModule(trace);
            String supplPathString = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
            Path path = new Path(supplPathString);
            IPath ssFile = path.addTrailingSeparator().append(ANALYSIS_ID).addFileExtension("ht");
            IPath segFile = path.addTrailingSeparator().append(ANALYSIS_ID).addFileExtension("dat");
            Assert.assertTrue((boolean)ssFile.toFile().exists());
            Assert.assertTrue((boolean)segFile.toFile().exists());
            TmfTraceClosedSignal signal = new TmfTraceClosedSignal((Object)this, trace);
            TmfTraceManager.getInstance().traceClosed(signal);
            trace.dispose();
            XmlUtils.deleteSupplementaryResources((String)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile().getName(), null);
            Assert.assertFalse((boolean)ssFile.toFile().exists());
            Assert.assertFalse((boolean)segFile.toFile().exists());
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }
}

