/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.views.properties;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.views.properties.PropertySheetConfiguration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManagerListener;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.properties.XMLPropertySource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLPropertySheetConfiguration
extends PropertySheetConfiguration {
    private CMDocumentManagerListenerImpl fCMDocumentManagerListener = new CMDocumentManagerListenerImpl();
    private PropertiesRefreshJob fPropertiesRefreshJob = null;
    IPropertySheetPage fPropertySheetPage = null;
    private IPropertySourceProvider fPropertySourceProvider = null;
    private INodeAdapter fRefreshAdapter = new XMLPropertySheetRefreshAdapter();
    private CMDocumentManager[] fSelectedCMDocumentManagers = new CMDocumentManager[0];
    private INodeNotifier[] fSelectedNotifiers = new INodeNotifier[0];

    public ISelection getInputSelection(IWorkbenchPart selectingPart, ISelection selection) {
        int i;
        if (this.fSelectedNotifiers != null) {
            i = 0;
            while (i < this.fSelectedNotifiers.length) {
                this.fSelectedNotifiers[i].removeAdapter(this.fRefreshAdapter);
                ++i;
            }
            this.fSelectedNotifiers = null;
        }
        i = 0;
        while (i < this.fSelectedCMDocumentManagers.length) {
            this.fSelectedCMDocumentManagers[i].removeListener((CMDocumentManagerListener)this.fCMDocumentManagerListener);
            ++i;
        }
        ISelection preferredSelection = selection;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSel = (IStructuredSelection)selection;
            Object[] selectedObjects = new Object[structuredSel.size()];
            System.arraycopy(structuredSel.toArray(), 0, selectedObjects, 0, selectedObjects.length);
            int i2 = 0;
            while (i2 < selectedObjects.length) {
                Object inode = selectedObjects[i2];
                if (inode instanceof Node) {
                    Node node = (Node)inode;
                    Node parentNode = node.getParentNode();
                    if (node.getNodeType() == 2) {
                        Element ownerElement = ((Attr)node).getOwnerElement();
                        selectedObjects[i2] = ownerElement;
                    } else if ((node.getNodeType() == 3 || node.getNodeType() == 4) && parentNode != null) {
                        selectedObjects[i2] = parentNode;
                    }
                }
                ++i2;
            }
            if (selectedObjects.length > 0) {
                HashSet<CMDocumentManager> managers = new HashSet<CMDocumentManager>(1);
                HashSet<Object> selectedNotifiers = new HashSet<Object>(1);
                int i3 = 0;
                while (i3 < selectedObjects.length) {
                    CMDocumentManager mgr;
                    ModelQuery query;
                    if (selectedObjects[i3] instanceof Node && (query = ModelQueryUtil.getModelQuery((Document)((Node)selectedObjects[i3]).getOwnerDocument())) != null && (mgr = query.getCMDocumentManager()) != null) {
                        managers.add(mgr);
                        mgr.addListener((CMDocumentManagerListener)this.fCMDocumentManagerListener);
                    }
                    if (selectedObjects[i3] instanceof INodeNotifier) {
                        selectedNotifiers.add(selectedObjects[i3]);
                        ((INodeNotifier)selectedObjects[i3]).addAdapter(this.fRefreshAdapter);
                    }
                    ++i3;
                }
                this.fSelectedCMDocumentManagers = managers.toArray(new CMDocumentManager[managers.size()]);
                this.fSelectedNotifiers = selectedNotifiers.toArray(new INodeNotifier[selectedNotifiers.size()]);
            }
            preferredSelection = new StructuredSelection(selectedObjects);
        }
        return preferredSelection;
    }

    PropertiesRefreshJob getPropertiesRefreshJob() {
        if (this.fPropertiesRefreshJob == null) {
            this.fPropertiesRefreshJob = new PropertiesRefreshJob();
        }
        return this.fPropertiesRefreshJob;
    }

    public IPropertySourceProvider getPropertySourceProvider(IPropertySheetPage page) {
        if (this.fPropertySourceProvider == null) {
            this.fPropertySheetPage = page;
            this.fPropertySourceProvider = new XMLPropertySourceProvider();
        }
        return this.fPropertySourceProvider;
    }

    public void unconfigure() {
        super.unconfigure();
        int i = 0;
        while (i < this.fSelectedCMDocumentManagers.length) {
            this.fSelectedCMDocumentManagers[i].removeListener((CMDocumentManagerListener)this.fCMDocumentManagerListener);
            ++i;
        }
        if (this.fPropertiesRefreshJob != null) {
            this.fPropertiesRefreshJob.cancel();
            this.fPropertiesRefreshJob.propertySheetPages = null;
        }
        this.fPropertySheetPage = null;
    }

    private class CMDocumentManagerListenerImpl
    implements CMDocumentManagerListener {
        private CMDocumentManagerListenerImpl() {
        }

        public void cacheCleared(CMDocumentCache cache) {
        }

        public void cacheUpdated(CMDocumentCache cache, String uri, int oldStatus, int newStatus, CMDocument cmDocument) {
            if (newStatus == 3 || newStatus == 4) {
                this.refreshPages();
            }
        }

        public void propertyChanged(CMDocumentManager cmDocumentManager, String propertyName) {
            if (cmDocumentManager.getPropertyEnabled("autoLoad")) {
                this.refreshPages();
            }
        }

        private void refreshPages() {
            XMLPropertySheetConfiguration.this.getPropertiesRefreshJob().addPropertySheetPage(XMLPropertySheetConfiguration.this.fPropertySheetPage);
            XMLPropertySheetConfiguration.this.getPropertiesRefreshJob().schedule(200L);
        }
    }

    private class PropertiesRefreshJob
    extends UIJob {
        public static final int UPDATE_DELAY = 200;
        Set propertySheetPages;

        public PropertiesRefreshJob() {
            super(XMLUIMessages.JFaceNodeAdapter_1);
            this.propertySheetPages = null;
            this.setSystem(true);
            this.setPriority(20);
            this.propertySheetPages = new HashSet(1);
        }

        void addPropertySheetPage(IPropertySheetPage page) {
            if (page != null && this.propertySheetPages != null) {
                this.propertySheetPages.add(page);
                this.schedule(200L);
            }
        }

        protected void canceling() {
            this.propertySheetPages.clear();
            super.canceling();
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Object[] pages = this.propertySheetPages.toArray();
            this.propertySheetPages.clear();
            int i = 0;
            while (i < pages.length) {
                PropertySheetPage page = (PropertySheetPage)pages[i];
                if (page != null && page.getControl() != null && !page.getControl().isDisposed()) {
                    page.refresh();
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
    }

    private class XMLPropertySheetRefreshAdapter
    implements INodeAdapter {
        private XMLPropertySheetRefreshAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            if (XMLPropertySheetConfiguration.this.fPropertySheetPage != null) {
                XMLPropertySheetConfiguration.this.getPropertiesRefreshJob().addPropertySheetPage(XMLPropertySheetConfiguration.this.fPropertySheetPage);
            }
        }
    }

    private class XMLPropertySourceProvider
    implements IPropertySourceProvider {
        private IPropertySource fPropertySource = null;
        private INodeNotifier fSource = null;

        private XMLPropertySourceProvider() {
        }

        public IPropertySource getPropertySource(Object object) {
            if (this.fSource != null && object.equals(this.fSource)) {
                return this.fPropertySource;
            }
            if (object instanceof IDOMNode) {
                this.fSource = (INodeNotifier)object;
                this.fPropertySource = (IPropertySource)this.fSource.getAdapterFor(IPropertySource.class);
                if (this.fPropertySource == null) {
                    this.fPropertySource = new XMLPropertySource((INodeNotifier)object){

                        @Override
                        public void setPropertyValue(Object nameObject, Object value) {
                            int i;
                            if (XMLPropertySheetConfiguration.this.fSelectedNotifiers != null) {
                                i = 0;
                                while (i < XMLPropertySheetConfiguration.this.fSelectedNotifiers.length) {
                                    XMLPropertySheetConfiguration.this.fSelectedNotifiers[i].removeAdapter(XMLPropertySheetConfiguration.this.fRefreshAdapter);
                                    ++i;
                                }
                            }
                            super.setPropertyValue(nameObject, value);
                            if (XMLPropertySheetConfiguration.this.fSelectedNotifiers != null) {
                                i = 0;
                                while (i < XMLPropertySheetConfiguration.this.fSelectedNotifiers.length) {
                                    XMLPropertySheetConfiguration.this.fSelectedNotifiers[i].addAdapter(XMLPropertySheetConfiguration.this.fRefreshAdapter);
                                    ++i;
                                }
                            }
                        }
                    };
                }
            } else {
                this.fSource = null;
                this.fPropertySource = null;
            }
            return this.fPropertySource;
        }
    }
}

