/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.dataprovider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;

@NonNullByDefault
public class DataProviderParameterUtils {
    public static final String REQUESTED_TIME_KEY = "requested_times";
    public static final String REQUESTED_TIMERANGE_KEY = "requested_timerange";
    public static final String REQUESTED_ITEMS_KEY = "requested_items";
    public static final String REQUESTED_TABLE_COUNT_KEY = "requested_table_count";
    public static final String REQUESTED_TABLE_INDEX_KEY = "requested_table_index";
    public static final String REQUESTED_COLUMN_IDS_KEY = "requested_table_column_ids";
    public static final String REQUESTED_ELEMENT_KEY = "requested_element";
    public static final String REQUESTED_MARKER_SET_KEY = "requested_marker_set";
    public static final String REQUESTED_MARKER_CATEGORIES_KEY = "requested_marker_categories";
    public static final String REQUESTED_TRACE_KEY = "requested_trace";
    public static final String FILTERED_KEY = "isFiltered";
    public static final String REGEX_MAP_FILTERS_KEY = "regex_map_filters";
    public static final String FULL_SEARCH_KEY = "full_search";
    public static final String TABLE_SEARCH_EXPRESSIONS_KEY = "table_search_expressions";
    public static final String TABLE_SEARCH_DIRECTION_KEY = "table_search_direction";

    private DataProviderParameterUtils() {
    }

    public static @Nullable List<Long> extractLongList(Map<String, Object> parameters, String key) {
        Object collectionObject = parameters.get(key);
        if (collectionObject instanceof Collection) {
            return DataProviderParameterUtils.transformToLongList((Collection)collectionObject);
        }
        return null;
    }

    public static @Nullable Boolean extractBoolean(Map<String, Object> parameters, String key) {
        Object booleanObject = parameters.get(key);
        if (booleanObject instanceof Boolean) {
            return (Boolean)booleanObject;
        }
        return null;
    }

    public static @Nullable List<Long> extractTimeRequested(Map<String, Object> parameters) {
        return DataProviderParameterUtils.extractLongList(parameters, REQUESTED_TIME_KEY);
    }

    public static @Nullable TimeRangeWithSamples extractTimeRangeWithSamples(Map<String, Object> parameters) {
        List<Long> timeRequested = DataProviderParameterUtils.extractLongList(parameters, REQUESTED_TIMERANGE_KEY);
        if (timeRequested == null || timeRequested.size() < 3) {
            return null;
        }
        return new TimeRangeWithSamples(timeRequested.get(0), timeRequested.get(1), timeRequested.get(2).intValue());
    }

    public static @Nullable List<Long> extractSelectedItems(Map<String, Object> parameters) {
        return DataProviderParameterUtils.extractLongList(parameters, REQUESTED_ITEMS_KEY);
    }

    public static @Nullable Boolean extractIsFiltered(Map<String, Object> parameters) {
        return DataProviderParameterUtils.extractBoolean(parameters, FILTERED_KEY);
    }

    public static @Nullable Multimap<Integer, String> extractRegexFilter(Map<String, Object> parameters) {
        Object regexesObject = parameters.get(REGEX_MAP_FILTERS_KEY);
        if (!(regexesObject instanceof Map)) {
            return null;
        }
        HashMultimap regexes = HashMultimap.create();
        Map regexesMap = (Map)regexesObject;
        regexesMap.forEach((arg_0, arg_1) -> DataProviderParameterUtils.lambda$0((Multimap)regexes, arg_0, arg_1));
        return regexes;
    }

    public static @Nullable Set<String> extractSelectedCategories(Map<String, Object> fetchParams) {
        HashSet<String> categories = null;
        Object fetched = fetchParams.get(REQUESTED_MARKER_CATEGORIES_KEY);
        if (fetched instanceof Iterable) {
            categories = new HashSet<String>();
            for (Object key : (Iterable)fetched) {
                if (key == null) continue;
                categories.add(String.valueOf(key));
            }
        }
        return categories;
    }

    private static @Nullable List<Long> transformToLongList(Collection<?> collectionToTransform) {
        if (!collectionToTransform.isEmpty()) {
            if (collectionToTransform instanceof List) {
                if (collectionToTransform.stream().allMatch(Long.class::isInstance)) {
                    return (List)collectionToTransform;
                }
            }
            if (collectionToTransform.stream().allMatch(Integer.class::isInstance)) {
                ArrayList<Long> list = new ArrayList<Long>();
                for (Integer element : (List)collectionToTransform) {
                    list.add(element.longValue());
                }
                return list;
            }
            ArrayList<Long> list = new ArrayList<Long>();
            for (Object element : collectionToTransform) {
                if (!(element instanceof Number)) {
                    return null;
                }
                list.add(((Number)element).longValue());
            }
            return list;
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void lambda$0(Multimap multimap, Object key, Collection value) {
        if (key instanceof String) {
            try {
                multimap.putAll((Object)Integer.valueOf((String)key), (Iterable)value);
            }
            catch (NumberFormatException e) {
                Activator.logError(e.getMessage(), e);
            }
        } else if (key instanceof Number) {
            multimap.putAll((Object)((Number)key).intValue(), (Iterable)value);
        }
    }

    public static enum Direction {
        NEXT,
        PREVIOUS;

    }

    public record TimeRangeWithSamples(long start, long end, int nbSamples) {
    }
}

