/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.parser.tests;

import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.eclipse.tracecompass.ctf.parser.CTFLexer;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CtfLexerTest {
    private final List<Token> tokens = new LinkedList<Token>();

    private void tokenize(String content) {
        ANTLRStringStream cs = new ANTLRStringStream(content);
        CTFLexer lexer = new CTFLexer((CharStream)cs);
        this.tokens.clear();
        Token token;
        while ((token = lexer.nextToken()) != Token.EOF_TOKEN) {
            this.tokens.add(token);
        }
        return;
    }

    private void checkToken(int type, String content) {
        Token token = this.tokens.remove(0);
        if (token.getType() != type) {
            Assert.fail((String)("Invalid type [value " + token.getType() + " but expect " + type + "]. Fail to tokenize:" + content));
        } else if (token.getText().compareTo(content) != 0) {
            Assert.fail((String)("Invalid content [value " + token.getText() + " but expect " + content + "]."));
        }
    }

    private void checkSingle(int type, String content) {
        this.tokenize(content);
        this.checkToken(type, content);
    }

    @Test
    public void testKeywords() {
        this.checkSingle(4, "align");
        this.checkSingle(20, "const");
        this.checkSingle(11, "char");
        this.checkSingle(25, "double");
        this.checkSingle(27, "enum");
        this.checkSingle(30, "event");
        this.checkSingle(31, "floating_point");
        this.checkSingle(32, "float");
        this.checkSingle(41, "integer");
        this.checkSingle(43, "int");
        this.checkSingle(46, "long");
        this.checkSingle(62, "short");
        this.checkSingle(64, "signed");
        this.checkSingle(66, "stream");
        this.checkSingle(68, "string");
        this.checkSingle(71, "struct");
        this.checkSingle(73, "trace");
        this.checkSingle(74, "typealias");
        this.checkSingle(75, "typedef");
        this.checkSingle(78, "unsigned");
        this.checkSingle(79, "variant");
        this.checkSingle(80, "void");
        this.checkSingle(8, "_Bool");
        this.checkSingle(19, "_Complex");
        this.checkSingle(39, "_Imaginary");
        this.checkSingle(28, "env");
        this.checkSingle(13, "clock");
        this.checkSingle(9, "callsite");
        this.checkSingle(49, "NaN");
        this.checkSingle(40, "+inf");
        this.checkSingle(50, "-inf");
    }

    @Test
    public void testSymbols() {
        this.tokenize(" , : ... ");
        this.checkToken(81, " ");
        this.checkToken(61, ",");
        this.checkToken(81, " ");
        this.checkToken(15, ":");
        this.checkToken(81, " ");
        this.checkToken(26, "...");
        this.checkToken(81, " ");
        this.tokenize(" = := = ");
        this.checkToken(81, " ");
        this.checkToken(6, "=");
        this.checkToken(81, " ");
        this.checkToken(76, ":=");
        this.checkToken(81, " ");
        this.tokenize(" <<>> ");
        this.checkToken(81, " ");
        this.checkToken(48, "<");
        this.checkToken(48, "<");
        this.checkToken(33, ">");
        this.checkToken(33, ">");
        this.checkToken(81, " ");
        this.tokenize(" ({[]}) ");
        this.checkToken(81, " ");
        this.checkToken(47, "(");
        this.checkToken(44, "{");
        this.checkToken(57, "[");
        this.checkToken(14, "]");
        this.checkToken(59, "}");
        this.checkToken(60, ")");
        this.checkToken(81, " ");
        this.tokenize(";;");
        this.checkToken(72, ";");
        this.checkToken(72, ";");
        this.tokenize(" ++ -- ");
        this.checkToken(81, " ");
        this.checkToken(63, "+");
        this.checkToken(63, "+");
        this.checkToken(81, " ");
        this.checkToken(63, "-");
        this.checkToken(63, "-");
        this.checkToken(81, " ");
        this.tokenize("-> .*.");
        this.checkToken(5, "->");
        this.checkToken(81, " ");
        this.checkToken(23, ".");
        this.checkToken(58, "*");
        this.checkToken(23, ".");
    }

    @Test
    public void testLiterals() {
        this.tokenize("01 02 010");
        this.checkToken(54, "01");
        this.checkToken(81, " ");
        this.checkToken(54, "02");
        this.checkToken(81, " ");
        this.checkToken(54, "010");
        this.tokenize("1 2 10 1024 ");
        this.checkToken(21, "1");
        this.checkToken(81, " ");
        this.checkToken(21, "2");
        this.checkToken(81, " ");
        this.checkToken(21, "10");
        this.checkToken(81, " ");
        this.checkToken(21, "1024");
        this.checkToken(81, " ");
        this.tokenize("0x01 0x02 0x0F0");
        this.checkToken(36, "0x01");
        this.checkToken(81, " ");
        this.checkToken(36, "0x02");
        this.checkToken(81, " ");
        this.checkToken(36, "0x0F0");
    }

    @Test
    public void testLiteralPrefixes() {
        this.checkSingle(36, "0x1");
        this.checkSingle(36, "0X1");
    }

    @Test
    public void testLiteralSuffixes() {
        this.checkSingle(21, "0l");
        this.checkSingle(21, "0L");
        this.checkSingle(21, "0ll");
        this.checkSingle(21, "0LL");
        this.checkSingle(21, "0ul");
        this.checkSingle(21, "0uL");
        this.checkSingle(21, "0ull");
        this.checkSingle(21, "0uLL");
        this.checkSingle(21, "0Ul");
        this.checkSingle(21, "0UL");
        this.checkSingle(21, "0Ull");
        this.checkSingle(21, "0ULL");
    }

    @Test
    public void testLiteralDigits() {
        this.checkSingle(54, "001234567");
        this.checkSingle(21, "123456");
        this.checkSingle(21, "987654");
        this.checkSingle(36, "0x012345");
        this.checkSingle(36, "0x678990");
        this.checkSingle(36, "0xABCDEF");
        this.checkSingle(36, "0xabcdef");
    }

    @Test
    public void testLiteralZero() {
        this.checkSingle(54, "00");
        this.checkSingle(21, "0");
        this.checkSingle(36, "0x0");
    }

    @Test
    public void testCharLiteral() {
        this.checkSingle(10, "'x'");
        this.checkSingle(10, "'\\''");
        this.checkSingle(10, "' '");
        this.checkSingle(10, "L'1'");
    }

    @Test
    public void testEscapeCharLiteral() {
        this.checkSingle(10, "'\\a'");
        this.checkSingle(10, "'\\b'");
        this.checkSingle(10, "'\\f'");
        this.checkSingle(10, "'\\n'");
        this.checkSingle(10, "'\\r'");
        this.checkSingle(10, "'\\t'");
        this.checkSingle(10, "'\\v'");
        this.checkSingle(10, "'\\''");
        this.checkSingle(10, "'\\\"'");
        this.checkSingle(10, "'\\\\'");
        this.checkSingle(10, "'\u0001'");
        this.checkSingle(10, "'\u0001'");
        this.checkSingle(10, "'\u0001'");
        this.checkSingle(10, "'\\x1A'");
        this.checkSingle(10, "'\\x1a'");
        this.checkSingle(10, "'\\xa'");
        this.checkSingle(10, "'\\x0'");
        this.checkSingle(10, "'\uabcd'");
        this.checkSingle(10, "'\u0123'");
        this.checkSingle(10, "'\u012345678'");
        this.checkSingle(10, "'\ufedcBA987'");
    }

    @Test
    public void testStringLiteral() {
        this.checkSingle(70, "\"\"");
        this.checkSingle(70, "\"x\"");
        this.checkSingle(70, "\"\\\"\"");
        this.checkSingle(70, "\" \"");
        this.checkSingle(70, "L\"1\"");
        this.checkSingle(70, "\"This is \\n a multiline\\r\\n\"");
        this.checkSingle(70, "L\"This is \\n a multiline\\r\\n\"");
    }

    @Test
    public void testEscapeStringLiteral() {
        this.checkSingle(70, "\"\\a\"");
        this.checkSingle(70, "\"\\b\"");
        this.checkSingle(70, "\"\\f\"");
        this.checkSingle(70, "\"\\n\"");
        this.checkSingle(70, "\"\\r\"");
        this.checkSingle(70, "\"\\t\"");
        this.checkSingle(70, "\"\\v\"");
        this.checkSingle(70, "\"\\'\"");
        this.checkSingle(70, "\"\\\"\"");
        this.checkSingle(70, "\"\\\\\"");
        this.checkSingle(70, "\"\u0001\"");
        this.checkSingle(70, "\"\u0001\"");
        this.checkSingle(70, "\"\u0001\"");
        this.checkSingle(70, "\"\\x1A\"");
        this.checkSingle(70, "\"\\x1a\"");
        this.checkSingle(70, "\"\\xa\"");
        this.checkSingle(70, "\"\\x0\"");
        this.checkSingle(70, "\"\uabcd\"");
        this.checkSingle(70, "\"\u0123\"");
        this.checkSingle(70, "\"\u012345678\"");
        this.checkSingle(70, "\"\ufedcBA987\"");
    }

    @Test
    public void testWhitespaces() {
        this.tokenize("  \r\t\n\f ");
        this.checkToken(81, " ");
        this.checkToken(81, " ");
        this.checkToken(81, "\r");
        this.checkToken(81, "\t");
        this.checkToken(81, "\n");
        this.checkToken(81, "\f");
        this.checkToken(81, " ");
    }

    @Test
    public void testComment() {
        this.tokenize(" /* test */ ");
        this.checkToken(81, " ");
        this.checkToken(16, "/* test */");
        this.checkToken(81, " ");
    }

    @Test
    public void testNestedComment() {
        this.tokenize(" /* /* */ ");
        this.checkToken(81, " ");
        this.checkToken(16, "/* /* */");
        this.checkToken(81, " ");
        this.tokenize(" /* /* * ** / */ ");
        this.checkToken(81, " ");
        this.checkToken(16, "/* /* * ** / */");
        this.checkToken(81, " ");
    }

    @Test
    public void testMultiLineComment() {
        this.tokenize(" /*\ntest\n*/ ");
        this.checkToken(81, " ");
        this.checkToken(16, "/*\ntest\n*/");
        this.checkToken(81, " ");
    }

    @Test
    public void testLineComment() {
        this.tokenize(" // asdad\r\n ");
        this.checkToken(81, " ");
        this.checkToken(45, "// asdad\r\n");
        this.checkToken(81, " ");
    }

    @Ignore(value="Lexer must be fixed first")
    @Test
    public void testLineCommentWithEOF() {
        this.tokenize("//");
        this.checkToken(45, "//");
    }

    @Test
    public void testMixedComment() {
        this.tokenize(" // /*\n");
        this.checkToken(81, " ");
        this.checkToken(45, "// /*\n");
        this.tokenize(" /*\n//\n*/ ");
        this.checkToken(81, " ");
        this.checkToken(16, "/*\n//\n*/");
        this.checkToken(81, " ");
    }

    @Test
    public void testIdentifier() {
        this.tokenize("_ a a1 B ");
        this.checkToken(38, "_");
        this.checkToken(81, " ");
        this.checkToken(38, "a");
        this.checkToken(81, " ");
        this.checkToken(38, "a1");
        this.checkToken(81, " ");
        this.checkToken(38, "B");
        this.checkToken(81, " ");
    }

    @Test
    public void testIdentifierLetters() {
        this.checkSingle(38, "ABCDEFGHI");
        this.checkSingle(38, "JKLMNOPQR");
        this.checkSingle(38, "STUVWXYZ");
        this.checkSingle(38, "abcdefghi");
        this.checkSingle(38, "jklmnopqr");
        this.checkSingle(38, "stuvwxyz");
        this.checkSingle(38, "_0123456789");
    }
}

