/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.callgraph;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.CallStackTestData;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.TestDataBigCallStack;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.TestDataSmallCallStack;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs.CallStackAnalysisStub;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ThreadNode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CallGraphWithCallStackAnalysisTest
extends CallStackTestBase {
    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"Small trace", new TestDataSmallCallStack()}, {"Big trace", new TestDataBigCallStack()});
    }

    public CallGraphWithCallStackAnalysisTest(String name, CallStackTestData data) {
        super(data);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testCallGraph() {
        CallStackAnalysisStub cga = this.getModule();
        ICallGraphProvider cg = cga.getCallGraph();
        Assert.assertTrue((boolean)(cg instanceof CallGraphAnalysis));
        CallGraphAnalysis callgraph = (CallGraphAnalysis)cg;
        callgraph.schedule();
        Assert.assertTrue((boolean)callgraph.waitForCompletion());
        @NonNull List threadNodes = callgraph.getThreadNodes();
        Assert.assertFalse((boolean)threadNodes.isEmpty());
        Map<Integer, Map<String, CallStackTestData.AggregateData>> expected = this.getTraceData().getExpectedCallGraph();
        Assert.assertEquals((String)"Number of threads", (long)expected.size(), (long)threadNodes.size());
        for (ThreadNode threadNode : threadNodes) {
            Map<String, CallStackTestData.AggregateData> expectedCg = expected.get((int)threadNode.getId());
            Assert.assertNotNull(expectedCg);
            CallGraphWithCallStackAnalysisTest.compareCallGraphs(expectedCg, threadNode.getChildren(), 0);
        }
    }

    private static void compareCallGraphs(Map<String, CallStackTestData.AggregateData> expected, Collection<AggregatedCalledFunction> actual, int depth) {
        for (AggregatedCalledFunction function : actual) {
            CallStackTestData.AggregateData aggregateData = expected.get(function.getSymbol());
            Assert.assertNotNull((String)("Unexpected function at depth " + depth + ": " + String.valueOf(function.getSymbol())), (Object)aggregateData);
            Assert.assertEquals((String)("Duration for " + String.valueOf(function.getSymbol()) + " at depth " + depth), (long)aggregateData.getDuration(), (long)function.getDuration());
            Assert.assertEquals((String)("Self time for " + String.valueOf(function.getSymbol()) + " at depth " + depth), (long)aggregateData.getSelfTime(), (long)function.getSelfTime());
            Assert.assertEquals((String)("Nb calls for " + String.valueOf(function.getSymbol()) + " at depth " + depth), (long)aggregateData.getNbCalls(), (long)function.getNbCalls());
            CallGraphWithCallStackAnalysisTest.compareCallGraphs(aggregateData.getChildren(), function.getChildren(), depth + 1);
        }
        Assert.assertEquals((String)"Total number of calls", (long)expected.size(), (long)actual.size());
    }
}

