/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.vectorization;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.logging.Logger;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.VectorSpecies;
import org.apache.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.internal.vectorization.PanamaVectorConstants;
import org.apache.lucene.internal.vectorization.PanamaVectorUtilSupport;
import org.apache.lucene.internal.vectorization.PostingDecodingUtil;
import org.apache.lucene.internal.vectorization.VectorUtilSupport;
import org.apache.lucene.internal.vectorization.VectorizationProvider;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SuppressForbidden;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class PanamaVectorizationProvider
extends VectorizationProvider {
    private final VectorUtilSupport vectorUtilSupport;

    @SuppressForbidden(reason="security manager")
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    PanamaVectorizationProvider() {
        try {
            PanamaVectorizationProvider.doPrivileged(() -> FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])new float[FloatVector.SPECIES_PREFERRED.length()], (int)0));
        }
        catch (SecurityException se) {
            throw new UnsupportedOperationException("We hit initialization failure described in JDK-8309727: " + se);
        }
        if (PanamaVectorConstants.PREFERRED_VECTOR_BITSIZE < 128) {
            throw new UnsupportedOperationException("Vector bit size is less than 128: " + PanamaVectorConstants.PREFERRED_VECTOR_BITSIZE);
        }
        this.vectorUtilSupport = new PanamaVectorUtilSupport();
        Logger log = Logger.getLogger(this.getClass().getName());
        log.info(String.format(Locale.ENGLISH, "Java vector incubator API enabled; uses preferredBitSize=%d%s%s", PanamaVectorConstants.PREFERRED_VECTOR_BITSIZE, Constants.HAS_FAST_VECTOR_FMA ? "; FMA enabled" : "", PanamaVectorConstants.HAS_FAST_INTEGER_VECTORS ? "" : "; floating-point vectors only"));
    }

    @Override
    public VectorUtilSupport getVectorUtilSupport() {
        return this.vectorUtilSupport;
    }

    @Override
    public FlatVectorsScorer getLucene99FlatVectorsScorer() {
        return DefaultFlatVectorScorer.INSTANCE;
    }

    @Override
    public PostingDecodingUtil newPostingDecodingUtil(IndexInput input) throws IOException {
        return new PostingDecodingUtil(input);
    }
}

