/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.criticalpath;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTmfGraphBuilderModule;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathAlgorithmException;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathAlgorithm;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathProvider;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.graph.WorkerSerializer;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.Activator;
import org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath.Messages;
import org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath.OSCriticalPathAlgorithm;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public abstract class AbstractCriticalPathModule
extends TmfAbstractAnalysisModule
implements ICriticalPathProvider {
    public static final String ANALYSIS_ID = "org.eclipse.tracecompass.analysis.graph.core.criticalpath";
    public static final String PARAM_WORKER = "workerid";
    private static final int CRITICAL_PATH_GRAPH_VERSION = 1;
    private final AbstractTmfGraphBuilderModule fGraphModule;
    private volatile @Nullable ITmfGraph fCriticalPath;
    private volatile boolean fScheduleOnParameterChange = true;

    public AbstractCriticalPathModule(AbstractTmfGraphBuilderModule graph) {
        this.addParameter(PARAM_WORKER);
        this.setId(ANALYSIS_ID);
        this.fGraphModule = graph;
    }

    @VisibleForTesting
    public AbstractCriticalPathModule(AbstractTmfGraphBuilderModule graph, IGraphWorker worker) {
        this(graph);
        this.fScheduleOnParameterChange = false;
        this.setParameter(PARAM_WORKER, worker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        Object workerObj = this.getParameter(PARAM_WORKER);
        if (workerObj == null) {
            return false;
        }
        if (!(workerObj instanceof IGraphWorker)) {
            throw new IllegalStateException("Worker parameter must be an IGraphWorker");
        }
        IGraphWorker worker = (IGraphWorker)workerObj;
        AbstractTmfGraphBuilderModule graphModule = this.fGraphModule;
        graphModule.schedule();
        monitor.setTaskName(NLS.bind((String)Messages.CriticalPathModule_waitingForGraph, (Object)graphModule.getName()));
        if (!graphModule.waitForCompletion(monitor)) {
            Activator.getInstance().logInfo("Critical path execution: graph building was cancelled.  Results may not be accurate.");
            return false;
        }
        ITmfGraph graph = graphModule.getTmfGraph();
        if (graph == null) {
            throw new TmfAnalysisException("Critical Path analysis: graph " + graphModule.getName() + " is null");
        }
        ITmfVertex head = graph.getHead(worker);
        if (head == null) {
            this.fCriticalPath = this.createGraph();
            return true;
        }
        ICriticalPathAlgorithm cp = AbstractCriticalPathModule.getAlgorithm(graph);
        try {
            ITmfGraph criticalPath = this.createGraph();
            if (criticalPath == null) {
                return false;
            }
            if (criticalPath.isDoneBuilding()) {
                boolean isSameWorker;
                ITmfVertex previousGraphHead = criticalPath.getHead();
                IGraphWorker previousGraphWorker = previousGraphHead == null ? null : criticalPath.getParentOf(previousGraphHead);
                IGraphWorker currentWorker = graph.getParentOf(head);
                boolean bl = isSameWorker = previousGraphWorker != null && AbstractCriticalPathModule.compareWorker(previousGraphWorker, currentWorker);
                if (isSameWorker) {
                    this.fCriticalPath = criticalPath;
                    return true;
                }
                criticalPath.dispose();
                this.getHistoryTreeFilePath().toFile().delete();
                criticalPath = this.createGraph();
            }
            criticalPath = cp.computeCriticalPath(criticalPath, head, null);
            criticalPath.closeGraph(Long.MAX_VALUE);
            this.fCriticalPath = criticalPath;
            return true;
        }
        catch (CriticalPathAlgorithmException e) {
            Activator.getInstance().logError(NonNullUtils.nullToEmptyString((Object)e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private static boolean compareWorker(IGraphWorker worker1, IGraphWorker worker2) {
        if (!worker1.getHostId().equals(worker2.getHostId())) {
            return false;
        }
        for (String key : worker1.getWorkerAspects().keySet()) {
            Object value1 = worker1.getWorkerAspects().get(key);
            Object value2 = worker2.getWorkerAspects().get(key);
            if (value1 == null && value2 == null || value1 != null && value2 != null && value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    private @Nullable ITmfGraph createGraph() {
        Path htFile = this.getHistoryTreeFilePath();
        ITmfTrace trace = this.fGraphModule.getTrace();
        if (trace == null) {
            throw new NullPointerException("The graph should not be created if there is no trace set");
        }
        return this.createGraphInstance(htFile, this.fGraphModule.getWorkerSerializer(), trace.getStartTime().toNanos(), 1);
    }

    private Path getHistoryTreeFilePath() {
        ITmfTrace trace = this.fGraphModule.getTrace();
        if (trace == null) {
            throw new NullPointerException("The graph should not be created if there is no trace set");
        }
        String fileDirectory = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        String id = this.fGraphModule.getId() + ".critPath";
        Path historyTreeFile = Paths.get(fileDirectory + id + ".ht", new String[0]);
        return historyTreeFile;
    }

    protected abstract @Nullable ITmfGraph createGraphInstance(Path var1, WorkerSerializer var2, long var3, int var5);

    protected void canceling() {
    }

    protected void parameterChanged(String name) {
        this.closeCriticalPath();
        this.cancel();
        this.resetAnalysis();
        if (this.fScheduleOnParameterChange) {
            this.schedule();
        }
    }

    public void dispose() {
        super.dispose();
        this.closeCriticalPath();
    }

    private void closeCriticalPath() {
        if (this.fCriticalPath != null) {
            this.fCriticalPath.dispose();
        }
        this.fCriticalPath = null;
    }

    private static ICriticalPathAlgorithm getAlgorithm(ITmfGraph graph) {
        return new OSCriticalPathAlgorithm(graph);
    }

    public boolean canExecute(ITmfTrace trace) {
        return true;
    }

    @Override
    public @Nullable ITmfGraph getCriticalPathGraph() {
        return this.fCriticalPath;
    }

    protected @NonNull String getFullHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.CriticalPathModule_fullHelpText);
    }

    protected @NonNull String getShortHelpText(ITmfTrace trace) {
        return this.getFullHelpText();
    }

    protected @NonNull String getTraceCannotExecuteHelpText(@NonNull ITmfTrace trace) {
        return NonNullUtils.nullToEmptyString((Object)Messages.CriticalPathModule_cantExecute);
    }
}

