/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.event;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceEventTypeFactory;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class GenericFtraceEvent
extends TmfEvent
implements ITmfSourceLookup {
    private final @Nullable ITmfCallsite fCallsite;
    private final @NonNull String fName;
    private final GenericFtraceField fField;

    public GenericFtraceEvent(ITmfTrace trace, long rank, GenericFtraceField field) {
        super(trace, rank, TmfTimestamp.fromNanos((long)field.getTs()), GenericFtraceEventTypeFactory.get(field.getName()), field.getContent());
        this.fField = field;
        this.fName = field.getName();
        this.fCallsite = null;
    }

    public ITmfEventField getContent() {
        return this.fField.getContent();
    }

    public @NonNull String getName() {
        return this.fName;
    }

    public @Nullable ITmfCallsite getCallsite() {
        return this.fCallsite;
    }

    public GenericFtraceField getField() {
        return this.fField;
    }
}

