/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.throughput.analysis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.Activator;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.throughput.analysis.AbstractPortQueueBuilder;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.throughput.analysis.DpdkEthdevThroughputAnalysisModule;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.throughput.analysis.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IODataPalette;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public abstract class AbstractDpdkEthdevThroughputDataProvider
extends AbstractTreeCommonXDataProvider<DpdkEthdevThroughputAnalysisModule, TmfTreeDataModel>
implements IOutputStyleProvider {
    private static final String BASE_STYLE = "base";
    private static final Map<String, OutputElementStyle> STATE_MAP;
    private static final List<Pair<String, String>> COLOR_LIST;
    private static final List<String> SUPPORTED_STYLES;
    protected static final String PORTS_LABEL;
    protected static final String RX_LABEL;
    protected static final String TX_LABEL;

    static {
        COLOR_LIST = IODataPalette.getColors();
        SUPPORTED_STYLES = ImmutableList.of((Object)"SOLID", (Object)"DASH", (Object)"DOT", (Object)"DASHDOT", (Object)"DASHDOTDOT");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)BASE_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"series-type", (Object)"area", (Object)"width", (Object)Float.valueOf(1.0f))));
        STATE_MAP = builder.build();
        PORTS_LABEL = Objects.requireNonNull(Messages.DpdkEthdev_ThroughputDataProvider_PORTS);
        RX_LABEL = Objects.requireNonNull(Messages.DpdkEthdev_ThroughputDataProvider_TRAFFIC_RX);
        TX_LABEL = Objects.requireNonNull(Messages.DpdkEthdev_ThroughputDataProvider_TRAFFIC_TX);
    }

    protected AbstractDpdkEthdevThroughputDataProvider(ITmfTrace trace, DpdkEthdevThroughputAnalysisModule module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
    }

    protected boolean isCacheable() {
        return true;
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(STATE_MAP), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    protected TmfTreeModel<TmfTreeDataModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) {
        ArrayList<TmfTreeDataModel> nodes = new ArrayList<TmfTreeDataModel>();
        long rootId = this.getId(-1);
        nodes.add(new TmfTreeDataModel(rootId, -1L, Collections.singletonList(Objects.requireNonNull(this.getTrace().getName())), false, null));
        try {
            int portsQuark = ss.getQuarkAbsolute(new String[]{"Ports"});
            long portsId = this.getId(portsQuark);
            nodes.add(new TmfTreeDataModel(portsId, rootId, Collections.singletonList(PORTS_LABEL), false, null));
            for (Integer portQuark : ss.getQuarks(new String[]{"Ports", "*"})) {
                String portName = ss.getAttributeName(portQuark.intValue());
                long portId = this.getId(portQuark);
                nodes.add(new TmfTreeDataModel(portId, portsId, Collections.singletonList(portName), false, null));
                int rxQsQuark = ss.optQuarkRelative(portQuark.intValue(), new String[]{"rx_qs"});
                int txQsQuark = ss.optQuarkRelative(portQuark.intValue(), new String[]{"tx_qs"});
                nodes.addAll(this.getQueuesTree(ss, rxQsQuark, portName, portId));
                nodes.addAll(this.getQueuesTree(ss, txQsQuark, portName, portId));
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getInstance().logError("Error getting the root attribute of Ports");
        }
        return new TmfTreeModel(Collections.emptyList(), nodes);
    }

    protected List<TmfTreeDataModel> getQueuesTree(ITmfStateSystem ss, int qsQuark, String portName, long portId) {
        int i = 0;
        ArrayList<TmfTreeDataModel> nodes = new ArrayList<TmfTreeDataModel>();
        boolean isRxQueue = true;
        try {
            if ("tx_qs".equals(ss.getAttributeName(qsQuark))) {
                isRxQueue = false;
            }
            long qsId = this.getId(qsQuark);
            nodes.add(new TmfTreeDataModel(qsId, portId, Collections.singletonList(isRxQueue ? RX_LABEL : TX_LABEL), false, null));
            for (Integer queueQuark : ss.getSubAttributes(qsQuark, false)) {
                String queueName = ss.getAttributeName(queueQuark.intValue());
                long queueId = this.getId(queueQuark);
                Pair<String, String> colorPair = COLOR_LIST.get(i % COLOR_LIST.size());
                String seriesStyle = SUPPORTED_STYLES.get(i / COLOR_LIST.size() % SUPPORTED_STYLES.size());
                nodes.add(new TmfTreeDataModel(queueId, qsId, Collections.singletonList(queueName), true, new OutputElementStyle(BASE_STYLE, (Map)ImmutableMap.of((Object)"color", (Object)(isRxQueue ? colorPair.getFirst() : colorPair.getSecond()), (Object)"series-style", (Object)seriesStyle, (Object)"style-name", (Object)(portName + "/" + (isRxQueue ? RX_LABEL : TX_LABEL) + "/" + queueName)))));
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Activator.getInstance().logWarning(e.getMessage());
        }
        return nodes;
    }

    protected abstract List<? extends AbstractPortQueueBuilder> initBuilders(ITmfStateSystem var1, SelectionTimeQueryFilter var2);
}

