/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.poll.stats.analysis;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.dpdk.core.trace.DpdkTrace;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.analysis.DpdkEthdevEventLayout;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.poll.stats.analysis.Messages;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysis;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableClass;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiDoubleNumber;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiLongNumber;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimestamp;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DpdkPollStatsAnalysis
extends LamiAnalysis {
    private static final long PROGRESS_INTERVAL = 1023L;
    private static final int MEMORY_SANITY_LIMIT = 40000;
    private final DpdkEthdevEventLayout fLayout = new DpdkEthdevEventLayout();

    public DpdkPollStatsAnalysis() {
        super(Objects.requireNonNull(Messages.EthdevPollStats_AnalysisName), false, trace -> true, Collections.emptyList());
    }

    protected synchronized void initialize() {
    }

    public boolean canExecute(ITmfTrace trace) {
        if (trace instanceof DpdkTrace) {
            return ((DpdkTrace)trace).validate(null, trace.getPath()).isOK();
        }
        return false;
    }

    private static int workRemaining(ITmfTrace trace) {
        return (int)Math.min(trace.getNbEvents() / 1024L, Integer.MAX_VALUE);
    }

    public List<LamiResultTable> execute(ITmfTrace trace, @Nullable TmfTimeRange timeRange, String extraParamsString, IProgressMonitor monitor) throws CoreException {
        AtomicLong done = new AtomicLong();
        HashMap<String, Map<String, List<Integer>>> pollCountMap = new HashMap<String, Map<String, List<Integer>>>();
        TmfTimeRange adjustedTimeRange = timeRange == null ? TmfTimeRange.ETERNITY : timeRange;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.EthdevPollStats_AnalysisName, (int)DpdkPollStatsAnalysis.workRemaining(trace));
        TmfEventRequest eventRequest = this.createEventRequest(trace, adjustedTimeRange, pollCountMap, subMonitor, done);
        trace.sendRequest((ITmfEventRequest)eventRequest);
        try {
            eventRequest.waitForCompletion();
            return this.convertToLamiTables(adjustedTimeRange, pollCountMap);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
    }

    private TmfEventRequest createEventRequest(final ITmfTrace trace, TmfTimeRange timeRange, final Map<String, Map<String, List<Integer>>> pollAspectCounts, final SubMonitor monitor, final AtomicLong nbProcessevents) {
        return new TmfEventRequest(ITmfEvent.class, timeRange, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND){

            public void handleData(ITmfEvent event) {
                if (monitor.isCanceled()) {
                    this.cancel();
                    return;
                }
                DpdkPollStatsAnalysis.this.processEvent(event, pollAspectCounts);
                if ((nbProcessevents.incrementAndGet() & 0x3FFL) == 0L) {
                    monitor.setWorkRemaining(DpdkPollStatsAnalysis.workRemaining(trace));
                    monitor.worked(1);
                    monitor.setTaskName(String.format("Dpdk Polls Statistics Analysis (%s events processed)", NumberFormat.getInstance().format(nbProcessevents.get())));
                }
            }
        };
    }

    private void processEvent(ITmfEvent event, Map<String, Map<String, List<Integer>>> pollCountsMap) {
        if (!event.getName().equals(this.fLayout.eventEthdevRxBurstNonEmpty())) {
            return;
        }
        Integer nbRxPkts = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldNbRxPkts()});
        Integer portId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldPortId()});
        Integer queueId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldQueueId()});
        String threadName = (String)event.getContent().getFieldValue(String.class, new String[]{this.fLayout.fieldThreadName()});
        if (nbRxPkts == null || portId == null || queueId == null || threadName == null) {
            return;
        }
        String queueName = "P" + String.valueOf(portId) + "/Q" + String.valueOf(queueId);
        DpdkPollStatsAnalysis.updatePollCountsMap(pollCountsMap, Objects.requireNonNull(Messages.EthdevPollStats_QueueLabel), queueName, nbRxPkts);
        DpdkPollStatsAnalysis.updatePollCountsMap(pollCountsMap, Objects.requireNonNull(Messages.EthdevPollStats_ThreadLabel), threadName, nbRxPkts);
    }

    private static void updatePollCountsMap(Map<String, Map<String, List<Integer>>> pollCountsMap, String aspectName, String key, Integer nbRxPkts) {
        Map dataSet = pollCountsMap.computeIfAbsent(aspectName, unused -> new HashMap());
        if (dataSet.size() < 40000) {
            List data = dataSet.computeIfAbsent(key, unused -> new ArrayList());
            data.add(nbRxPkts);
        }
    }

    private List<LamiResultTable> convertToLamiTables(TmfTimeRange timeRange, Map<String, Map<String, List<Integer>>> pollAspectCounts) {
        ArrayList<LamiResultTable> results = new ArrayList<LamiResultTable>();
        for (Map.Entry<String, Map<String, List<Integer>>> entry : pollAspectCounts.entrySet()) {
            Map<String, List<Integer>> dataSet = Objects.requireNonNull(entry.getValue());
            ArrayList<LamiTableEntry> entries = new ArrayList<LamiTableEntry>();
            for (Map.Entry<String, List<Integer>> element : dataSet.entrySet()) {
                List<Integer> pollValues = Objects.requireNonNull(element.getValue());
                int nbSuccessfulPolls = pollValues.size();
                int minPollValue = (Integer)Collections.min((Collection)element.getValue());
                int maxPollValue = (Integer)Collections.max((Collection)element.getValue());
                double avgPollValue = pollValues.stream().mapToInt(i -> i).average().orElse(0.0);
                double sd = pollValues.stream().mapToDouble(val -> Math.pow((double)val.intValue() - avgPollValue, 2.0)).sum();
                double std = Math.sqrt(sd / (double)pollValues.size());
                double stdRounded = (double)Math.round(std * 100.0) / 100.0;
                List<LamiData> data = Arrays.asList(new LamiData[]{new LamiString(element.getKey()), new LamiLongNumber(Long.valueOf(minPollValue)), new LamiLongNumber(Long.valueOf(maxPollValue)), new LamiLongNumber(Long.valueOf((long)avgPollValue)), new LamiDoubleNumber(Double.valueOf(stdRounded)), new LamiLongNumber(Long.valueOf(nbSuccessfulPolls))});
                entries.add(new LamiTableEntry(data));
            }
            List<LamiTableEntryAspect> tableAspects = Arrays.asList(new LamiTableEntryAspect[]{new LamiCategoryAspect(entry.getKey(), 0), new LamiCountAspect(Objects.requireNonNull(Messages.EthdevPollStats_MinimumValueLabel), 1), new LamiCountAspect(Objects.requireNonNull(Messages.EthdevPollStats_MaximumValueLabel), 2), new LamiCountAspect(Objects.requireNonNull(Messages.EthdevPollStats_AverageValueLabel), 3), new LamiCountAspect(Objects.requireNonNull(Messages.EthdevPollStats_StandardDeviationLabel), 4), new LamiCountAspect(Objects.requireNonNull(Messages.EthdevPollStats_CountLabel), 5)});
            LamiTableClass tableClass = new LamiTableClass(entry.getKey(), entry.getKey(), tableAspects, Collections.emptySet());
            LamiResultTable lrt = new LamiResultTable(DpdkPollStatsAnalysis.createTimeRange(timeRange), tableClass, entries);
            results.add(lrt);
        }
        return results;
    }

    private static LamiTimeRange createTimeRange(TmfTimeRange timeRange) {
        return new LamiTimeRange(new LamiTimestamp(timeRange.getStartTime().toNanos()), new LamiTimestamp(timeRange.getEndTime().toNanos()));
    }

    private final class LamiCategoryAspect
    extends LamiGenericAspect {
        private LamiCategoryAspect(String name, int column) {
            super(name, null, column, false, false);
        }
    }

    private final class LamiCountAspect
    extends LamiGenericAspect {
        private LamiCountAspect(String name, int column) {
            super(name, null, column, true, false);
        }
    }

    private final class LamiString
    extends LamiData {
        private final String fElement;

        private LamiString(String element) {
            this.fElement = element;
        }

        public @Nullable String toString() {
            return this.fElement;
        }
    }
}

