/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.util.List;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaVariable;

public class VarResolver
extends TemplateVariableResolver {
    private final String fDefaultType;
    private String fType;

    public VarResolver() {
        this("java.lang.Object");
    }

    VarResolver(String defaultType) {
        this.fDefaultType = defaultType;
    }

    public void resolve(TemplateVariable variable, TemplateContext context) {
        List params = variable.getVariableType().getParams();
        this.fType = params.size() == 0 ? this.fDefaultType : (String)params.get(0);
        if (variable instanceof JavaVariable) {
            JavaContext jc = (JavaContext)context;
            JavaVariable jv = (JavaVariable)variable;
            jv.setParamType(this.fType);
            CompilationUnitCompletion.Variable[] localLariables = jc.getLocalVariables(this.fType);
            CompilationUnitCompletion.Variable[] fields = jc.getFields(this.fType);
            Object[] variables = new CompilationUnitCompletion.Variable[localLariables.length + fields.length];
            System.arraycopy(fields, 0, variables, 0, fields.length);
            System.arraycopy(localLariables, 0, variables, fields.length, localLariables.length);
            if (variables.length <= 0) {
                super.resolve(variable, context);
                return;
            }
            jv.setChoices(variables);
            jc.markAsUsed(jv.getDefaultValue());
            if (variables.length > 1) {
                variable.setUnambiguous(false);
            } else {
                variable.setUnambiguous(this.isUnambiguous(context));
            }
        } else {
            super.resolve(variable, context);
        }
    }

    protected String[] resolveAll(TemplateContext context) {
        JavaContext jc = (JavaContext)context;
        CompilationUnitCompletion.Variable[] localVariables = jc.getLocalVariables(this.fType);
        CompilationUnitCompletion.Variable[] fields = jc.getFields(this.fType);
        CompilationUnitCompletion.Variable[] variables = new CompilationUnitCompletion.Variable[localVariables.length + fields.length];
        System.arraycopy(fields, 0, variables, 0, fields.length);
        System.arraycopy(localVariables, 0, variables, fields.length, localVariables.length);
        String[] names = new String[variables.length];
        int i = 0;
        while (i < variables.length) {
            names[i] = variables[i].getName();
            ++i;
        }
        if (names.length > 0) {
            jc.markAsUsed(names[0]);
        }
        return names;
    }
}

