/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.sign;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.ease.Logger;
import org.eclipse.ease.sign.ScriptSignatureException;
import org.eclipse.ease.sign.SignatureHelper;

public class PerformSignature {
    public static KeyStore loadKeyStore(InputStream inputStream, String type, String provider, String keyStorePass) throws ScriptSignatureException, UnrecoverableKeyException, IOException {
        if (inputStream == null) {
            throw new ScriptSignatureException("Given location of keystore can't be accessed.");
        }
        if (type == null || type.isEmpty() || "default".equalsIgnoreCase(type)) {
            type = KeyStore.getDefaultType();
        }
        if ("".equals(provider) || "preferred".equalsIgnoreCase(provider)) {
            provider = null;
        }
        try {
            KeyStore keyStore = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            keyStore.load(inputStream, keyStorePass.toCharArray());
            Logger.info("org.eclipse.ease", "Keystore loaded");
            return keyStore;
        }
        catch (KeyStoreException e) {
            Logger.error("org.eclipse.ease", Arrays.toString(e.getStackTrace()), e);
            throw new ScriptSignatureException("No provider support '" + type + "' type of keystore.", e);
        }
        catch (NoSuchProviderException e) {
            throw new ScriptSignatureException("No such provider available.", e);
        }
        catch (IOException e) {
            Logger.error("org.eclipse.ease", Arrays.toString(e.getStackTrace()), e);
            if (e.getCause() instanceof UnrecoverableKeyException) {
                throw new UnrecoverableKeyException("Invalid Keystore Password");
            }
            if (e.getCause() instanceof FileNotFoundException || e.getCause() instanceof SecurityException) {
                throw new ScriptSignatureException("File can't be read. Chose another keystore or try again.", e);
            }
            throw new IOException("Error loading keystore");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ScriptSignatureException("Algorithm used for securing keystore can't be found. Chose another Keystore", e);
        }
        catch (CertificateException e) {
            throw new ScriptSignatureException("Some certificate/s in keystore can't be loaded", e);
        }
    }

    public static Collection<String> getAliases(KeyStore keyStore) {
        try {
            if (keyStore != null) {
                ArrayList<String> aliasList = new ArrayList<String>();
                for (String alias : Collections.list(keyStore.aliases())) {
                    if (!keyStore.isKeyEntry(alias)) continue;
                    aliasList.add(alias);
                }
                return aliasList;
            }
        }
        catch (KeyStoreException e) {
            return null;
        }
        return null;
    }

    public static String getCertificate(KeyStore keyStore, String alias, boolean canAttachSelfSign) throws ScriptSignatureException {
        if (alias == null) {
            throw new ScriptSignatureException("Alias is null. Try again.");
        }
        if (keyStore != null) {
            try {
                if (!keyStore.containsAlias(alias)) {
                    throw new ScriptSignatureException("Alias can't be found");
                }
                if (SignatureHelper.isSelfSignedCertificate(keyStore.getCertificateChain(alias)[0]) && !canAttachSelfSign) {
                    throw new ScriptSignatureException("This certificate is self-signed certificate. Chose another trusted certificate.");
                }
                Certificate[] certificateChain = keyStore.getCertificateChain(alias);
                if (certificateChain == null) {
                    throw new ScriptSignatureException("Not a valid Certificate chain");
                }
                StringBuffer certStrBuf = new StringBuffer();
                Certificate[] certificateArray = certificateChain;
                int n = certificateChain.length;
                int n2 = 0;
                while (n2 < n) {
                    Certificate cert = certificateArray[n2];
                    certStrBuf.append(String.valueOf(SignatureHelper.convertBytesToBase64(cert.getEncoded())) + ":");
                    ++n2;
                }
                return certStrBuf.toString();
            }
            catch (KeyStoreException e) {
                Logger.error("org.eclipse.ease", "Keystore not initialized properly. Try Again.", e);
                return null;
            }
            catch (CertificateEncodingException e) {
                throw new ScriptSignatureException("Encoding of certificate is improper. Please try again or chose another alias.", e);
            }
        }
        Logger.error("org.eclipse.ease", "Keystore not initialized properly. Try Again.");
        return null;
    }

    private static byte[] getSignature(Signature signature, InputStream dataStream) throws ScriptSignatureException {
        byte[] buffer = new byte[1024];
        BufferedInputStream bf = new BufferedInputStream(dataStream);
        try {
            int len;
            while ((len = bf.read(buffer)) >= 0) {
                signature.update(buffer, 0, len);
            }
            byte[] byArray = signature.sign();
            return byArray;
        }
        catch (SignatureException e) {
            throw new ScriptSignatureException("Signature is not successful. Try again.", e);
        }
        catch (IOException e) {
            throw new ScriptSignatureException("An error occured while reading file.", e);
        }
        finally {
            try {
                if (bf != null) {
                    bf.close();
                }
            }
            catch (IOException e) {
                Logger.error("org.eclipse.ease", Arrays.toString(e.getStackTrace()), e);
            }
        }
    }

    public static String createSignature(KeyStore keyStore, InputStream dataStream, String alias, String privateKeyPass, String provider, String messageDigestAlgo) throws ScriptSignatureException, UnrecoverableKeyException {
        if (alias == null || privateKeyPass == null) {
            throw new ScriptSignatureException("Alias or private key password is null. Try again.");
        }
        if ("".equals(provider) || "preferred".equalsIgnoreCase(provider)) {
            provider = null;
        }
        if (messageDigestAlgo == null || messageDigestAlgo.isEmpty() || "default".equalsIgnoreCase(messageDigestAlgo)) {
            messageDigestAlgo = "SHA256";
        }
        if (keyStore != null) {
            try {
                if (!keyStore.containsAlias(alias)) {
                    throw new ScriptSignatureException("Alias can't be found. Try again.");
                }
                if (!keyStore.isKeyEntry(alias)) {
                    throw new ScriptSignatureException("Keystore does not contain alias. Please chose another alias.");
                }
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, privateKeyPass.toCharArray());
                String encryptionAlgo = privateKey.getAlgorithm();
                if (!encryptionAlgo.equals("DSA") && !encryptionAlgo.equals("RSA")) {
                    throw new ScriptSignatureException("Key contain invalid algorithm. It must contain DSA or RSA.");
                }
                Signature signature = provider == null ? Signature.getInstance(String.valueOf(messageDigestAlgo) + "with" + encryptionAlgo) : Signature.getInstance(String.valueOf(messageDigestAlgo) + "with" + encryptionAlgo, provider);
                provider = signature.getProvider().getName();
                signature.initSign(privateKey);
                byte[] signByte = PerformSignature.getSignature(signature, dataStream);
                Logger.info("org.eclipse.ease", "Signature performed.");
                String signStr = SignatureHelper.convertBytesToBase64(signByte);
                return String.valueOf(provider) + ":" + signStr;
            }
            catch (KeyStoreException e) {
                Logger.error("org.eclipse.ease", "Keystore not initialized properly. Try Again.", e);
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                throw new ScriptSignatureException(e.getMessage(), e);
            }
            catch (NoSuchProviderException e) {
                throw new ScriptSignatureException("No such provider available. Chose another provider.", e);
            }
            catch (InvalidKeyException e) {
                throw new ScriptSignatureException("Key is invalid. Please try again or chose another alias.", e);
            }
        }
        Logger.error("org.eclipse.ease", "Keystore not initialized properly. Try Again.");
        return null;
    }
}

