/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.internal.core.dom.util.DOMASTUtil;

public class MethodDeclaration
extends BodyDeclaration {
    public static final ChildPropertyDescriptor JAVADOC_PROPERTY = MethodDeclaration.internalJavadocPropertyFactory(MethodDeclaration.class);
    public static final SimplePropertyDescriptor MODIFIERS_PROPERTY = MethodDeclaration.internalModifiersPropertyFactory(MethodDeclaration.class);
    public static final ChildListPropertyDescriptor MODIFIERS2_PROPERTY = MethodDeclaration.internalModifiers2PropertyFactory(MethodDeclaration.class);
    public static final SimplePropertyDescriptor CONSTRUCTOR_PROPERTY = new SimplePropertyDescriptor(MethodDeclaration.class, "constructor", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor COMPACT_CONSTRUCTOR_PROPERTY = new SimplePropertyDescriptor(MethodDeclaration.class, "compactConstructor", Boolean.TYPE, false);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(MethodDeclaration.class, "name", SimpleName.class, true, false);
    public static final ChildPropertyDescriptor RETURN_TYPE_PROPERTY = new ChildPropertyDescriptor(MethodDeclaration.class, "returnType", Type.class, true, false);
    public static final ChildPropertyDescriptor RETURN_TYPE2_PROPERTY = new ChildPropertyDescriptor(MethodDeclaration.class, "returnType2", Type.class, false, false);
    public static final SimplePropertyDescriptor EXTRA_DIMENSIONS_PROPERTY = new SimplePropertyDescriptor(MethodDeclaration.class, "extraDimensions", Integer.TYPE, true);
    public static final ChildListPropertyDescriptor EXTRA_DIMENSIONS2_PROPERTY = new ChildListPropertyDescriptor(MethodDeclaration.class, "extraDimensions2", Dimension.class, false);
    public static final ChildListPropertyDescriptor TYPE_PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(MethodDeclaration.class, "typeParameters", TypeParameter.class, false);
    public static final ChildListPropertyDescriptor PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(MethodDeclaration.class, "parameters", SingleVariableDeclaration.class, true);
    public static final ChildPropertyDescriptor RECEIVER_TYPE_PROPERTY = new ChildPropertyDescriptor(MethodDeclaration.class, "receiverType", Type.class, false, false);
    public static final ChildPropertyDescriptor RECEIVER_QUALIFIER_PROPERTY = new ChildPropertyDescriptor(MethodDeclaration.class, "receiverQualifier", SimpleName.class, false, false);
    public static final ChildListPropertyDescriptor THROWN_EXCEPTIONS_PROPERTY = new ChildListPropertyDescriptor(MethodDeclaration.class, "thrownExceptions", Name.class, false);
    public static final ChildListPropertyDescriptor THROWN_EXCEPTION_TYPES_PROPERTY = new ChildListPropertyDescriptor(MethodDeclaration.class, "thrownExceptionTypes", Type.class, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(MethodDeclaration.class, "body", Block.class, false, true);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private static final List PROPERTY_DESCRIPTORS_8_0;
    private static final List PROPERTY_DESCRIPTORS_9_0;
    private boolean isConstructor = false;
    private boolean isCompactConstructor = false;
    private volatile SimpleName methodName;
    private volatile Type optionalReceiverType;
    private volatile SimpleName optionalReceiverQualifier;
    private final ASTNode.NodeList parameters = new ASTNode.NodeList(PARAMETERS_PROPERTY);
    private Type returnType = null;
    private boolean returnType2Initialized = false;
    private ASTNode.NodeList typeParameters = null;
    private int extraArrayDimensions = 0;
    private ASTNode.NodeList extraDimensions = null;
    private ASTNode.NodeList thrownExceptions = null;
    private ASTNode.NodeList thrownExceptionTypes = null;
    private Block optionalBody = null;

    static {
        ArrayList propertyList = new ArrayList(10);
        MethodDeclaration.createPropertyList(MethodDeclaration.class, propertyList);
        MethodDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        MethodDeclaration.addProperty(MODIFIERS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(CONSTRUCTOR_PROPERTY, propertyList);
        MethodDeclaration.addProperty(RETURN_TYPE_PROPERTY, propertyList);
        MethodDeclaration.addProperty(NAME_PROPERTY, propertyList);
        MethodDeclaration.addProperty(PARAMETERS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(EXTRA_DIMENSIONS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(THROWN_EXCEPTIONS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(BODY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = MethodDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(11);
        MethodDeclaration.createPropertyList(MethodDeclaration.class, propertyList);
        MethodDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        MethodDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        MethodDeclaration.addProperty(CONSTRUCTOR_PROPERTY, propertyList);
        MethodDeclaration.addProperty(TYPE_PARAMETERS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(RETURN_TYPE2_PROPERTY, propertyList);
        MethodDeclaration.addProperty(NAME_PROPERTY, propertyList);
        MethodDeclaration.addProperty(PARAMETERS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(EXTRA_DIMENSIONS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(THROWN_EXCEPTIONS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(BODY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = MethodDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(13);
        MethodDeclaration.createPropertyList(MethodDeclaration.class, propertyList);
        MethodDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        MethodDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        MethodDeclaration.addProperty(CONSTRUCTOR_PROPERTY, propertyList);
        MethodDeclaration.addProperty(TYPE_PARAMETERS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(RETURN_TYPE2_PROPERTY, propertyList);
        MethodDeclaration.addProperty(NAME_PROPERTY, propertyList);
        MethodDeclaration.addProperty(RECEIVER_TYPE_PROPERTY, propertyList);
        MethodDeclaration.addProperty(RECEIVER_QUALIFIER_PROPERTY, propertyList);
        MethodDeclaration.addProperty(PARAMETERS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(EXTRA_DIMENSIONS2_PROPERTY, propertyList);
        MethodDeclaration.addProperty(THROWN_EXCEPTION_TYPES_PROPERTY, propertyList);
        MethodDeclaration.addProperty(BODY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_8_0 = MethodDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(14);
        MethodDeclaration.createPropertyList(MethodDeclaration.class, propertyList);
        MethodDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        MethodDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        MethodDeclaration.addProperty(CONSTRUCTOR_PROPERTY, propertyList);
        MethodDeclaration.addProperty(TYPE_PARAMETERS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(RETURN_TYPE2_PROPERTY, propertyList);
        MethodDeclaration.addProperty(NAME_PROPERTY, propertyList);
        MethodDeclaration.addProperty(RECEIVER_TYPE_PROPERTY, propertyList);
        MethodDeclaration.addProperty(RECEIVER_QUALIFIER_PROPERTY, propertyList);
        MethodDeclaration.addProperty(PARAMETERS_PROPERTY, propertyList);
        MethodDeclaration.addProperty(EXTRA_DIMENSIONS2_PROPERTY, propertyList);
        MethodDeclaration.addProperty(THROWN_EXCEPTION_TYPES_PROPERTY, propertyList);
        MethodDeclaration.addProperty(BODY_PROPERTY, propertyList);
        MethodDeclaration.addProperty(COMPACT_CONSTRUCTOR_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_9_0 = MethodDeclaration.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        if (apiLevel < 8) {
            return PROPERTY_DESCRIPTORS_3_0;
        }
        if (DOMASTUtil.isRecordDeclarationSupported(apiLevel)) {
            return PROPERTY_DESCRIPTORS_9_0;
        }
        return PROPERTY_DESCRIPTORS_8_0;
    }

    MethodDeclaration(AST ast) {
        super(ast);
        if (ast.apiLevel >= 3) {
            this.typeParameters = new ASTNode.NodeList(TYPE_PARAMETERS_PROPERTY);
        }
        if (ast.apiLevel < 8) {
            this.thrownExceptions = new ASTNode.NodeList(THROWN_EXCEPTIONS_PROPERTY);
        } else {
            this.extraDimensions = new ASTNode.NodeList(EXTRA_DIMENSIONS2_PROPERTY);
            this.thrownExceptionTypes = new ASTNode.NodeList(THROWN_EXCEPTION_TYPES_PROPERTY);
        }
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return MethodDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == MODIFIERS_PROPERTY) {
            if (get) {
                return this.getModifiers();
            }
            this.internalSetModifiers(value);
            return 0;
        }
        if (property == EXTRA_DIMENSIONS_PROPERTY) {
            if (get) {
                return this.getExtraDimensions();
            }
            this.setExtraDimensions(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == CONSTRUCTOR_PROPERTY) {
            if (get) {
                return this.isConstructor();
            }
            this.setConstructor(value);
            return false;
        }
        if (property == COMPACT_CONSTRUCTOR_PROPERTY) {
            if (get) {
                return this.isCompactConstructor();
            }
            this.setCompactConstructor(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == JAVADOC_PROPERTY) {
            if (get) {
                return this.getJavadoc();
            }
            this.setJavadoc((Javadoc)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == RETURN_TYPE_PROPERTY) {
            if (get) {
                return this.getReturnType();
            }
            this.setReturnType((Type)child);
            return null;
        }
        if (property == RETURN_TYPE2_PROPERTY) {
            if (get) {
                return this.getReturnType2();
            }
            this.setReturnType2((Type)child);
            return null;
        }
        if (property == RECEIVER_TYPE_PROPERTY) {
            if (get) {
                return this.getReceiverType();
            }
            this.setReceiverType((Type)child);
            return null;
        }
        if (property == RECEIVER_QUALIFIER_PROPERTY) {
            if (get) {
                return this.getReceiverQualifier();
            }
            this.setReceiverQualifier((SimpleName)child);
            return null;
        }
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS2_PROPERTY) {
            return this.modifiers();
        }
        if (property == TYPE_PARAMETERS_PROPERTY) {
            return this.typeParameters();
        }
        if (property == PARAMETERS_PROPERTY) {
            return this.parameters();
        }
        if (property == THROWN_EXCEPTIONS_PROPERTY) {
            return this.thrownExceptions();
        }
        if (property == THROWN_EXCEPTION_TYPES_PROPERTY) {
            return this.thrownExceptionTypes();
        }
        if (property == EXTRA_DIMENSIONS2_PROPERTY) {
            return this.extraDimensions();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ChildPropertyDescriptor internalJavadocProperty() {
        return JAVADOC_PROPERTY;
    }

    @Override
    final ChildListPropertyDescriptor internalModifiers2Property() {
        return MODIFIERS2_PROPERTY;
    }

    @Override
    final SimplePropertyDescriptor internalModifiersProperty() {
        return MODIFIERS_PROPERTY;
    }

    @Override
    final int getNodeType0() {
        return 31;
    }

    @Override
    ASTNode clone0(AST target) {
        MethodDeclaration result = new MethodDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setJavadoc((Javadoc)ASTNode.copySubtree(target, this.getJavadoc()));
        if (this.ast.apiLevel == 2) {
            result.internalSetModifiers(this.getModifiers());
            result.setReturnType((Type)ASTNode.copySubtree(target, this.getReturnType()));
        }
        if (this.ast.apiLevel >= 3) {
            result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
            result.typeParameters().addAll(ASTNode.copySubtrees(target, this.typeParameters()));
            result.setReturnType2((Type)ASTNode.copySubtree(target, this.getReturnType2()));
        }
        result.setConstructor(this.isConstructor());
        result.setName((SimpleName)this.getName().clone(target));
        if (this.ast.apiLevel >= 8) {
            result.setReceiverType((Type)ASTNode.copySubtree(target, this.getReceiverType()));
            result.setReceiverQualifier((SimpleName)ASTNode.copySubtree(target, this.getReceiverQualifier()));
        }
        result.parameters().addAll(ASTNode.copySubtrees(target, this.parameters()));
        if (this.ast.apiLevel >= 8) {
            result.extraDimensions().addAll(ASTNode.copySubtrees(target, this.extraDimensions()));
        } else {
            result.setExtraDimensions(this.getExtraDimensions());
        }
        if (this.ast.apiLevel() >= 8) {
            result.thrownExceptionTypes().addAll(ASTNode.copySubtrees(target, this.thrownExceptionTypes()));
        } else {
            result.thrownExceptions().addAll(ASTNode.copySubtrees(target, this.thrownExceptions()));
        }
        if (DOMASTUtil.isRecordDeclarationSupported(this.ast)) {
            result.setCompactConstructor(this.isCompactConstructor());
        }
        result.setBody((Block)ASTNode.copySubtree(target, this.getBody()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getJavadoc());
            if (this.ast.apiLevel == 2) {
                this.acceptChild(visitor, this.getReturnType());
            } else {
                this.acceptChildren(visitor, this.modifiers);
                this.acceptChildren(visitor, this.typeParameters);
                this.acceptChild(visitor, this.getReturnType2());
            }
            this.acceptChild(visitor, this.getName());
            if (this.ast.apiLevel >= 8) {
                this.acceptChild(visitor, this.optionalReceiverType);
                this.acceptChild(visitor, this.optionalReceiverQualifier);
            }
            this.acceptChildren(visitor, this.parameters);
            if (this.ast.apiLevel() >= 8) {
                this.acceptChildren(visitor, this.extraDimensions);
                this.acceptChildren(visitor, this.thrownExceptionTypes);
            } else {
                this.acceptChildren(visitor, this.thrownExceptions);
            }
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void setConstructor(boolean isConstructor) {
        this.preValueChange(CONSTRUCTOR_PROPERTY);
        this.isConstructor = isConstructor;
        this.postValueChange(CONSTRUCTOR_PROPERTY);
    }

    public boolean isCompactConstructor() {
        this.unsupportedBelow16();
        return this.isCompactConstructor;
    }

    public void setCompactConstructor(boolean isCompactConstructor) {
        this.unsupportedBelow16();
        this.preValueChange(COMPACT_CONSTRUCTOR_PROPERTY);
        this.isCompactConstructor = isCompactConstructor;
        this.postValueChange(COMPACT_CONSTRUCTOR_PROPERTY);
    }

    public List typeParameters() {
        if (this.typeParameters == null) {
            this.unsupportedIn2();
        }
        return this.typeParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleName getName() {
        if (this.methodName == null) {
            MethodDeclaration methodDeclaration = this;
            synchronized (methodDeclaration) {
                if (this.methodName == null) {
                    this.preLazyInit();
                    this.methodName = new SimpleName(this.ast);
                    this.postLazyInit(this.methodName, NAME_PROPERTY);
                }
            }
        }
        return this.methodName;
    }

    public void setName(SimpleName methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this.methodName;
        this.preReplaceChild(oldChild, methodName, NAME_PROPERTY);
        this.methodName = methodName;
        this.postReplaceChild(oldChild, methodName, NAME_PROPERTY);
    }

    public Type getReceiverType() {
        this.unsupportedIn2_3_4();
        return this.optionalReceiverType;
    }

    public void setReceiverType(Type receiverType) {
        this.unsupportedIn2_3_4();
        Type oldChild = this.optionalReceiverType;
        this.preReplaceChild(oldChild, receiverType, RECEIVER_TYPE_PROPERTY);
        this.optionalReceiverType = receiverType;
        this.postReplaceChild(oldChild, receiverType, RECEIVER_TYPE_PROPERTY);
    }

    public SimpleName getReceiverQualifier() {
        this.unsupportedIn2_3_4();
        return this.optionalReceiverQualifier;
    }

    public void setReceiverQualifier(SimpleName receiverQualifier) {
        this.unsupportedIn2_3_4();
        SimpleName oldChild = this.optionalReceiverQualifier;
        this.preReplaceChild(oldChild, receiverQualifier, RECEIVER_QUALIFIER_PROPERTY);
        this.optionalReceiverQualifier = receiverQualifier;
        this.postReplaceChild(oldChild, receiverQualifier, RECEIVER_QUALIFIER_PROPERTY);
    }

    public List parameters() {
        return this.parameters;
    }

    public boolean isVarargs() {
        if (this.modifiers == null) {
            this.unsupportedIn2();
        }
        if (this.parameters().isEmpty()) {
            return false;
        }
        SingleVariableDeclaration v = (SingleVariableDeclaration)this.parameters().get(this.parameters().size() - 1);
        return v.isVarargs();
    }

    public List thrownExceptions() {
        return this.internalThrownExceptions();
    }

    List internalThrownExceptions() {
        if (this.thrownExceptions == null) {
            this.supportedOnlyIn2_3_4();
        }
        return this.thrownExceptions;
    }

    public List thrownExceptionTypes() {
        if (this.thrownExceptionTypes == null) {
            this.unsupportedIn2_3_4();
        }
        return this.thrownExceptionTypes;
    }

    public Type getReturnType() {
        return this.internalGetReturnType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Type internalGetReturnType() {
        this.supportedOnlyIn2();
        if (this.returnType == null) {
            MethodDeclaration methodDeclaration = this;
            synchronized (methodDeclaration) {
                if (this.returnType == null) {
                    this.preLazyInit();
                    this.returnType = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    this.postLazyInit(this.returnType, RETURN_TYPE_PROPERTY);
                }
            }
        }
        return this.returnType;
    }

    public void setReturnType(Type type) {
        this.internalSetReturnType(type);
    }

    void internalSetReturnType(Type type) {
        this.supportedOnlyIn2();
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Type oldChild = this.returnType;
        this.preReplaceChild(oldChild, type, RETURN_TYPE_PROPERTY);
        this.returnType = type;
        this.postReplaceChild(oldChild, type, RETURN_TYPE_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getReturnType2() {
        this.unsupportedIn2();
        if (this.returnType == null && !this.returnType2Initialized) {
            MethodDeclaration methodDeclaration = this;
            synchronized (methodDeclaration) {
                if (this.returnType == null && !this.returnType2Initialized) {
                    this.preLazyInit();
                    this.returnType = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    this.returnType2Initialized = true;
                    this.postLazyInit(this.returnType, RETURN_TYPE2_PROPERTY);
                }
            }
        }
        return this.returnType;
    }

    public void setReturnType2(Type type) {
        this.unsupportedIn2();
        this.returnType2Initialized = true;
        Type oldChild = this.returnType;
        this.preReplaceChild(oldChild, type, RETURN_TYPE2_PROPERTY);
        this.returnType = type;
        this.postReplaceChild(oldChild, type, RETURN_TYPE2_PROPERTY);
    }

    public int getExtraDimensions() {
        if (this.extraDimensions == null) {
            return this.extraArrayDimensions;
        }
        return this.extraDimensions.size();
    }

    public void setExtraDimensions(int dimensions) {
        if (this.extraDimensions != null) {
            this.supportedOnlyIn2_3_4();
        }
        if (dimensions < 0) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(EXTRA_DIMENSIONS_PROPERTY);
        this.extraArrayDimensions = dimensions;
        this.postValueChange(EXTRA_DIMENSIONS_PROPERTY);
    }

    public List extraDimensions() {
        if (this.extraDimensions == null) {
            this.unsupportedIn2_3_4();
        }
        return this.extraDimensions;
    }

    public Block getBody() {
        return this.optionalBody;
    }

    public void setBody(Block body) {
        Block oldChild = this.optionalBody;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.optionalBody = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public IMethodBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveMethod(this);
    }

    @Override
    int memSize() {
        return super.memSize() + 52;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.optionalDocComment == null ? 0 : this.getJavadoc().treeSize()) + (this.modifiers == null ? 0 : this.modifiers.listSize()) + (this.typeParameters == null ? 0 : this.typeParameters.listSize()) + (this.methodName == null ? 0 : this.getName().treeSize()) + (this.optionalReceiverType == null ? 0 : this.optionalReceiverType.treeSize()) + (this.optionalReceiverQualifier == null ? 0 : this.optionalReceiverQualifier.treeSize()) + (this.returnType == null ? 0 : this.returnType.treeSize()) + this.parameters.listSize() + (this.ast.apiLevel < 8 ? this.thrownExceptions.listSize() : this.extraDimensions.listSize() + this.thrownExceptionTypes.listSize()) + (this.optionalBody == null ? 0 : this.getBody().treeSize());
    }
}

