/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.nodes;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.AbstractRosStateProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.nodes.RosNodesAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RosNodesStateProvider
extends AbstractRosStateProvider {
    private static int VERSION_NUMBER = 0;

    public RosNodesStateProvider(ITmfTrace trace) {
        super(trace, RosNodesAnalysis.getFullAnalysisId());
    }

    @Override
    public int getVersion() {
        return VERSION_NUMBER;
    }

    @Override
    protected void eventHandle(@NonNull ITmfEvent event) {
        super.eventHandle(event);
        if (!RosNodesStateProvider.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        long timestamp = event.getTimestamp().toNanos();
        if (RosNodesStateProvider.isEvent(event, this.fLayout.eventInitNode())) {
            String nodeNameFull = this.getNodeName(event);
            long processId = this.getProcessId(event);
            int nodeNameQuark = ss.getQuarkAbsoluteAndAdd(new String[]{nodeNameFull});
            ss.modifyAttribute(timestamp, (Object)processId, nodeNameQuark);
            return;
        }
        if (RosNodesStateProvider.isEvent(event, this.fLayout.eventShutdownNode())) {
            String nodeName = this.getNodeName(event);
            int nodeNameQuark = ss.getQuarkAbsoluteAndAdd(new String[]{nodeName});
            ss.modifyAttribute(timestamp, null, nodeNameQuark);
            return;
        }
    }
}

