/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.trace;

import java.util.Map;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class LocationGroup {
    private final long fId;
    private final long fParentId;
    private final long fNameId;
    private final int fType;

    public LocationGroup(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Long id = (Long)content.getFieldValue(Long.class, new String[]{"self"});
        this.fId = id == null ? 0xFFFFFFFFL : id;
        Long parentId = (Long)content.getFieldValue(Long.class, new String[]{"systemTreeParent"});
        this.fParentId = parentId == null ? 0xFFFFFFFFL : parentId;
        Long nameId = (Long)content.getFieldValue(Long.class, new String[]{"name"});
        this.fNameId = nameId == null ? 0xFFFFFFFFL : nameId;
        Integer type = (Integer)content.getFieldValue(Integer.class, new String[]{"locationGroupType"});
        this.fType = type == null ? 255 : type;
    }

    public String getFullName(Map<Integer, String> stringIdMap) {
        String name = stringIdMap.get((int)this.fNameId);
        if (this.fType > 0 && name != null) {
            return name;
        }
        return "UNKNOWN";
    }

    public long getId() {
        return this.fId;
    }

    public long getParentId() {
        return this.fParentId;
    }
}

