/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.IRosConnectionsModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.RosConnection;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.IRosMessagesTransportModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.RosMessageTransport;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.RosMessagesTransportEventMatching;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.RosMessagesTransportEventMatchingProcessing;
import org.eclipse.tracecompass.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RosMessagesTransportModel
implements IRosMessagesTransportModel {
    private static RosMessagesTransportEventMatching sfMatching = null;
    private final @NonNull IRosConnectionsModel fConnectionsModel;
    private final RosMessagesTransportEventMatchingProcessing fProcessingUnit;
    private final TmfEventMatching fMatching;
    private Collection<RosMessageTransport> fMessageTransports = null;

    public RosMessagesTransportModel(ITmfTrace trace, @NonNull IRosConnectionsModel connectionsModel) {
        this.fConnectionsModel = connectionsModel;
        this.fProcessingUnit = new RosMessagesTransportEventMatchingProcessing(this.fConnectionsModel);
        this.fMatching = new TmfEventMatching(Collections.singleton(Objects.requireNonNull(trace)), (IMatchProcessingUnit)this.fProcessingUnit);
    }

    @Override
    public void generateModel() {
        if (sfMatching == null) {
            sfMatching = new RosMessagesTransportEventMatching();
            TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)sfMatching);
        }
        this.fMatching.matchEvents();
        this.fMessageTransports = this.fProcessingUnit.getMatches();
    }

    @Override
    public @Nullable RosMessageTransport getNextMessageTransport(long timestamp, String node, String topicName) {
        if (this.fMessageTransports == null) {
            return null;
        }
        RosConnection connection = this.fConnectionsModel.getConnectionFromNodePublishingOnTopic(node, topicName);
        if (connection == null) {
            Activator.getInstance().logError("Could not find connection!");
            return null;
        }
        long matchDiff = Long.MAX_VALUE;
        RosMessageTransport match = null;
        for (RosMessageTransport transport : this.fMessageTransports) {
            long diff;
            if (!transport.getConnection().equals(connection) || (diff = transport.getSourceTimestamp() - timestamp) >= matchDiff) continue;
            matchDiff = diff;
            match = transport;
        }
        if (match == null) {
            Activator.getInstance().logError("Could not find closest transport!");
        }
        return match;
    }

    @Override
    public @Nullable Collection<RosMessageTransport> getMessageTransports() {
        return Collections.unmodifiableCollection(this.fMessageTransports);
    }
}

