/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers.internal;

import org.eclipse.ease.ui.help.hovers.IHoverContentProvider;
import org.eclipse.ease.ui.help.hovers.internal.ControlHoverManager;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class TreeViewerHoverManager
extends ControlHoverManager {
    private final TreeViewer fTreeViewer;

    public TreeViewerHoverManager(TreeViewer treeViewer, Control hoverArea, IWidgetTokenOwner owner, IHoverContentProvider hoverContent) {
        super((Control)treeViewer.getTree(), hoverArea, owner, hoverContent);
        this.fTreeViewer = treeViewer;
    }

    @Override
    protected Rectangle getHoverInterestArea() {
        TreeItem item = this.fTreeViewer.getTree().getItem(this.getHoverEventLocation());
        Rectangle area = item.getBounds();
        area.x = 0;
        area.width = item.getParent().getBounds().width;
        int offset = 0;
        int[] nArray = this.fTreeViewer.getTree().getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (offset + this.fTreeViewer.getTree().getColumn(index).getWidth() < this.getHoverEventLocation().x) {
                offset += this.fTreeViewer.getTree().getColumn(index).getWidth();
            } else {
                area.x = offset;
                area.width = this.fTreeViewer.getTree().getColumn(index).getWidth();
                break;
            }
            ++n2;
        }
        return area;
    }

    @Override
    protected Object getHoverOrigin() {
        TreeItem item = this.fTreeViewer.getTree().getItem(this.getHoverEventLocation());
        return item != null ? this.fTreeViewer : null;
    }

    @Override
    protected Object getHoverDetails() {
        TreeItem item = this.fTreeViewer.getTree().getItem(this.getHoverEventLocation());
        return item != null ? item.getData() : null;
    }
}

