/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.ui.view.spanlife;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.analysis.spanlife.SpanLifeEntryModel;
import org.eclipse.tracecompass.incubator.internal.opentracing.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.opentracing.ui.view.spanlife.SpanLifePresentationProvider;
import org.eclipse.tracecompass.incubator.internal.opentracing.ui.view.spanlife.SpanMarkerEvent;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class SpanLifeView
extends BaseDataProviderTimeGraphView {
    public static final String ID = "org.eclipse.tracecompass.incubator.opentracing.ui.view.life.spanlife.view";
    private static final RGBA MARKER_COLOR = new RGBA(200, 0, 0, 150);
    private static final Image ERROR_IMAGE = Objects.requireNonNull(Activator.getDefault()).getImageFromPath("icons/delete_button.gif");

    public SpanLifeView() {
        this(ID, new SpanLifePresentationProvider(), "org.eclipse.tracecompass.incubator.opentracing.analysis.spanlife.dataprovider");
        this.setTreeLabelProvider(new SpanTreeLabelProvider());
    }

    public SpanLifeView(String id, TimeGraphPresentationProvider pres, String dpID) {
        super(id, pres, dpID);
    }

    /*
     * WARNING - void declaration
     */
    protected @NonNull List<IMarkerEvent> getViewMarkerList(Iterable<@NonNull TimeGraphEntry> entries, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        void var12_12;
        ITimeGraphEntry[] expandedElements = this.getTimeGraphViewer().getExpandedElements();
        List<Object> queriedElements = new ArrayList();
        ITimeGraphEntry[] iTimeGraphEntryArray = expandedElements;
        int n = expandedElements.length;
        boolean n2 = false;
        while (var12_12 < n) {
            ITimeGraphEntry candidate = iTimeGraphEntryArray[var12_12];
            if (StreamSupport.stream(entries.spliterator(), false).anyMatch(candidate::equals)) {
                queriedElements.add(candidate);
            }
            ++var12_12;
        }
        if (queriedElements.isEmpty()) {
            queriedElements = Arrays.asList(expandedElements);
        }
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        for (ITimeGraphEntry iTimeGraphEntry : queriedElements) {
            ITmfTreeDataModel entryModel = ((TimeGraphEntry)iTimeGraphEntry).getEntryModel();
            if (!(entryModel instanceof SpanLifeEntryModel)) continue;
            SpanLifeEntryModel model = (SpanLifeEntryModel)entryModel;
            for (SpanLifeEntryModel.LogEvent log : model.getLogs()) {
                markers.add((IMarkerEvent)new SpanMarkerEvent(iTimeGraphEntry, log.getTime(), MARKER_COLOR, log.getType()));
            }
        }
        return markers;
    }

    protected void buildEntryList(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, @NonNull IProgressMonitor monitor) {
        super.buildEntryList(parentTrace instanceof TmfExperiment ? parentTrace : trace, parentTrace, monitor);
    }

    private static class SpanTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private SpanTreeLabelProvider() {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            TimeGraphEntry entry;
            ITmfTreeDataModel entryModel;
            if (columnIndex == 0 && element instanceof TimeGraphEntry && (entryModel = (entry = (TimeGraphEntry)element).getEntryModel()) instanceof SpanLifeEntryModel && ((SpanLifeEntryModel)entryModel).getErrorTag()) {
                return ERROR_IMAGE;
            }
            return null;
        }
    }
}

