/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.hudson.maven.core.trace;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.hudson.maven.core.trace.MavenTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTrace;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTraceEvent;

public class MavenEvent
extends TextTraceEvent {
    public static final @NonNull ITmfEventAspect<Double> DURATION_ASPECT = new MavenEventAspect<Double>("Duration", "Time taken by the event", event -> {
        if (event instanceof MavenEvent) {
            return ((MavenEvent)event).fDuration;
        }
        return null;
    });
    public static final @NonNull ITmfEventAspect<String> ELEMENT_ASPECT = new MavenEventAspect<String>("Element", "Element of the event", event -> {
        if (event instanceof MavenEvent) {
            return ((MavenEvent)event).fElement;
        }
        return null;
    });
    public static final @NonNull ITmfEventAspect<String> FULL_GROUP_ASPECT = new MavenEventAspect<String>("Full Group", "Full group of the event", event -> {
        if (event instanceof MavenEvent) {
            return ((MavenEvent)event).fFullGroup;
        }
        return null;
    });
    public static final TmfEventType GOAL_TYPE = new TmfEventType("Goal", null);
    public static final @NonNull ITmfEventAspect<String> GROUP_ASPECT = new MavenEventAspect<String>("Group", "Group of the event", event -> {
        if (event instanceof MavenEvent) {
            return ((MavenEvent)event).fGroup;
        }
        return null;
    });
    private static final @NonNull ITmfEventAspect<Level> LEVEL_ASPECT = new MavenEventAspect<Level>("Log Level", "Log levle of the event", event -> {
        if (event instanceof MavenEvent) {
            return ((MavenEvent)event).fLevel;
        }
        return null;
    });
    public static final TmfEventType SUMMARY_TYPE = new TmfEventType("Summary", null);
    public static final TmfEventType TEST_TYPE = new TmfEventType("Test", null);
    public static final @NonNull Iterable<@NonNull ITmfEventAspect<?>> EVENT_ASPECTS = ImmutableList.of((Object)TmfBaseAspects.getTimestampAspect(), (Object)TmfBaseAspects.getEventTypeAspect(), LEVEL_ASPECT, GROUP_ASPECT, DURATION_ASPECT, ELEMENT_ASPECT, FULL_GROUP_ASPECT);
    private final Double fDuration;
    private final String fElement;
    private final String fFullGroup;
    private final String fGroup;
    private final Level fLevel;

    public static MavenEvent createGoal(MavenTrace mavenTrace, @NonNull ITmfTimestamp timestamp, String level, String group, String fullGroup, String element) {
        return new MavenEvent(mavenTrace, timestamp, GOAL_TYPE, Level.parse(level), fullGroup, group, element);
    }

    public static MavenEvent createSummary(MavenTrace mavenTrace, @NonNull ITmfTimestamp timestamp, String group, String fullGroup, double duration) {
        return new MavenEvent(mavenTrace, timestamp, SUMMARY_TYPE, group, fullGroup, duration);
    }

    public static MavenEvent createTest(MavenTrace mavenTrace, @NonNull ITmfTimestamp timestamp, String group, String fullGroup, double duration) {
        return new MavenEvent(mavenTrace, timestamp, TEST_TYPE, group, fullGroup, duration);
    }

    public MavenEvent() {
        super(null, null, null, null);
        this.fGroup = null;
        this.fFullGroup = null;
        this.fDuration = null;
        this.fLevel = null;
        this.fElement = null;
    }

    private MavenEvent(MavenTrace mavenTrace, @NonNull ITmfTimestamp timestamp, TmfEventType eventType, Level level, String fullGroup, String group, String element) {
        super((TextTrace)mavenTrace, timestamp, (ITmfEventType)eventType, null);
        this.fGroup = group;
        this.fFullGroup = fullGroup;
        this.fElement = element;
        this.fLevel = level;
        this.fDuration = null;
    }

    private MavenEvent(MavenTrace mavenTrace, @NonNull ITmfTimestamp timestamp, TmfEventType eventType, String group, String fullGroup, double duration) {
        super((TextTrace)mavenTrace, timestamp, (ITmfEventType)eventType, null);
        this.fGroup = group;
        this.fFullGroup = fullGroup;
        this.fDuration = duration;
        this.fElement = null;
        this.fLevel = Level.FINE;
    }

    @NonNullByDefault
    private static final class MavenEventAspect<T>
    implements ITmfEventAspect<T> {
        private String fDescription;
        private String fName;
        private Function<ITmfEvent, T> fResolver;

        public MavenEventAspect(String name, String description, Function<ITmfEvent, T> resolver) {
            this.fName = name;
            this.fDescription = description;
            this.fResolver = resolver;
        }

        public String getHelpText() {
            return this.fDescription;
        }

        public String getName() {
            return this.fName;
        }

        public @Nullable T resolve(@NonNull ITmfEvent event) {
            return this.fResolver.apply(event);
        }
    }
}

