/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.Arrays;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IBuildContext;
import org.eclipse.core.runtime.Assert;

public class BuildContext
implements IBuildContext {
    private final IBuildConfiguration buildConfiguration;
    private final IBuildConfiguration[] requestedBuilt;
    private final IBuildConfiguration[] buildOrder;

    public BuildContext(IBuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
        this.buildOrder = new IBuildConfiguration[]{buildConfiguration};
        this.requestedBuilt = this.buildOrder;
    }

    public BuildContext(IBuildConfiguration buildConfiguration, IBuildConfiguration[] requestedBuilt, IBuildConfiguration[] buildOrder) {
        this.buildConfiguration = buildConfiguration;
        this.requestedBuilt = requestedBuilt;
        this.buildOrder = buildOrder;
    }

    private int findBuildConfigurationIndex() {
        int position = -1;
        int i = 0;
        while (i < this.buildOrder.length) {
            if (this.buildOrder[i].equals(this.buildConfiguration)) {
                position = i;
                break;
            }
            ++i;
        }
        Assert.isTrue((position >= 0 && position < this.buildOrder.length ? 1 : 0) != 0);
        return position;
    }

    @Override
    public IBuildConfiguration[] getRequestedConfigs() {
        return (IBuildConfiguration[])this.requestedBuilt.clone();
    }

    @Override
    public IBuildConfiguration[] getAllReferencedBuildConfigs() {
        int position = this.findBuildConfigurationIndex();
        IBuildConfiguration[] builtBefore = new IBuildConfiguration[position];
        System.arraycopy(this.buildOrder, 0, builtBefore, 0, builtBefore.length);
        return builtBefore;
    }

    @Override
    public IBuildConfiguration[] getAllReferencingBuildConfigs() {
        int position = this.findBuildConfigurationIndex();
        IBuildConfiguration[] builtAfter = new IBuildConfiguration[this.buildOrder.length - position - 1];
        System.arraycopy(this.buildOrder, position + 1, builtAfter, 0, builtAfter.length);
        return builtAfter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.buildConfiguration.hashCode();
        result = 31 * result + Arrays.hashCode(this.requestedBuilt);
        result = 31 * result + Arrays.hashCode(this.buildOrder);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildContext other = (BuildContext)obj;
        return this.buildConfiguration.equals(other.buildConfiguration) && Arrays.equals(this.requestedBuilt, other.requestedBuilt) && Arrays.equals(this.buildOrder, other.buildOrder);
    }
}

