/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.TestTemplateTestDescriptor;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.support.hierarchical.Node;

final class TestTemplateExtensionContext
extends AbstractExtensionContext<TestTemplateTestDescriptor> {
    private final TestInstances testInstances;

    TestTemplateExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, TestTemplateTestDescriptor testDescriptor, JupiterConfiguration configuration, TestInstances testInstances, Function<ExtensionContext, ExecutableInvoker> executableInvokerFactory) {
        super(parent, engineExecutionListener, testDescriptor, configuration, executableInvokerFactory);
        this.testInstances = testInstances;
    }

    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    public Optional<Class<?>> getTestClass() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
        return this.getParent().flatMap(ExtensionContext::getTestInstanceLifecycle);
    }

    public Optional<Object> getTestInstance() {
        return this.getTestInstances().map(TestInstances::getInnermostInstance);
    }

    public Optional<TestInstances> getTestInstances() {
        return Optional.ofNullable(this.testInstances);
    }

    public Optional<Method> getTestMethod() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    public Optional<Throwable> getExecutionException() {
        return Optional.empty();
    }

    @Override
    protected Node.ExecutionMode getPlatformExecutionMode() {
        return ((TestTemplateTestDescriptor)this.getTestDescriptor()).getExecutionMode();
    }
}

