/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import com.overzealous.remark.Options;
import com.overzealous.remark.Remark;
import java.io.Reader;
import java.lang.reflect.Field;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.javadoc.AbstractJavaDocConverter;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Safelist;

public class JavaDoc2MarkdownConverter
extends AbstractJavaDocConverter {
    private static Remark remark;

    static {
        Options options = new Options();
        options.tables = Options.Tables.MULTI_MARKDOWN;
        options.hardwraps = true;
        options.inlineLinks = true;
        options.autoLinks = true;
        options.reverseHtmlSmartPunctuation = true;
        remark = new Remark(options);
        try {
            Field cleanerField = Remark.class.getDeclaredField("cleaner");
            cleanerField.setAccessible(true);
            Cleaner c = (Cleaner)cleanerField.get(remark);
            Field safelistField = Cleaner.class.getDeclaredField("safelist");
            safelistField.setAccessible(true);
            Safelist s = (Safelist)safelistField.get(c);
            s.addProtocols("a", "href", new String[]{"file", "jdt"});
            s.addProtocols("img", "src", new String[]{"file"});
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            JavaLanguageServerPlugin.logException("Unable to modify jsoup to include file and jdt protocols", e);
        }
    }

    public JavaDoc2MarkdownConverter(Reader reader) {
        super(reader);
    }

    public JavaDoc2MarkdownConverter(String javadoc) {
        super(javadoc);
    }

    @Override
    String convert(String rawHtml) {
        return remark.convert(rawHtml);
    }
}

