/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.cds;

import java.io.File;
import jdk.test.lib.StringArrayUtils;
import jdk.test.lib.cds.CDSOptions;
import jdk.test.lib.cds.CDSTestUtils;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;
import jdk.test.whitebox.WhiteBox;
import jtreg.SkippedException;

public abstract class CDSAppTester {
    private final String name;
    private final String classListFile;
    private final String classListFileLog;
    private final String aotConfigurationFile;
    private final String aotConfigurationFileLog;
    private final String staticArchiveFile;
    private final String staticArchiveFileLog;
    private final String aotCacheFile;
    private final String aotCacheFileLog;
    private final String dynamicArchiveFile;
    private final String dynamicArchiveFileLog;
    private final String tempBaseArchiveFile;
    private int numProductionRuns = 0;
    private String whiteBoxJar = null;
    private boolean inOneStepTraining = false;
    private Workflow workflow;
    private boolean checkExitValue = true;

    public CDSAppTester(String name) {
        if (CDSTestUtils.DYNAMIC_DUMP) {
            throw new SkippedException("Tests based on CDSAppTester should be excluded when -Dtest.dynamic.cds.archive is specified");
        }
        this.name = name;
        this.classListFile = this.name() + ".classlist";
        this.classListFileLog = CDSAppTester.logFileName(this.classListFile);
        this.aotConfigurationFile = this.name() + ".aotconfig";
        this.aotConfigurationFileLog = CDSAppTester.logFileName(this.aotConfigurationFile);
        this.staticArchiveFile = this.name() + ".static.jsa";
        this.staticArchiveFileLog = CDSAppTester.logFileName(this.staticArchiveFile);
        this.aotCacheFile = this.name() + ".aot";
        this.aotCacheFileLog = CDSAppTester.logFileName(this.aotCacheFile);
        this.dynamicArchiveFile = this.name() + ".dynamic.jsa";
        this.dynamicArchiveFileLog = CDSAppTester.logFileName(this.dynamicArchiveFile);
        this.tempBaseArchiveFile = this.name() + ".temp-base.jsa";
    }

    private String productionRunLog() {
        if (this.numProductionRuns == 0) {
            return CDSAppTester.logFileName(this.name() + ".production");
        }
        return CDSAppTester.logFileName(this.name() + ".production." + this.numProductionRuns);
    }

    private static String logFileName(String file) {
        file = file.replace("\"", "%22");
        file = file.replace("'", "%27");
        return file + ".log";
    }

    public boolean isDumping(RunMode runMode) {
        if (this.isStaticWorkflow()) {
            return runMode == RunMode.DUMP_STATIC;
        }
        if (this.isDynamicWorkflow()) {
            return runMode == RunMode.DUMP_DYNAMIC;
        }
        if (this.isAOTWorkflow()) {
            return runMode == RunMode.TRAINING || runMode == RunMode.ASSEMBLY;
        }
        return false;
    }

    public final String name() {
        return this.name;
    }

    public String[] vmArgs(RunMode runMode) {
        return new String[0];
    }

    public String classpath(RunMode runMode) {
        return null;
    }

    public String modulepath(RunMode runMode) {
        return null;
    }

    public abstract String[] appCommandLine(RunMode var1);

    public void checkExecution(OutputAnalyzer out, RunMode runMode) throws Exception {
    }

    public final void setCheckExitValue(boolean b) {
        this.checkExitValue = b;
    }

    public final void useWhiteBox(String whiteBoxJar) {
        this.whiteBoxJar = whiteBoxJar;
    }

    public final boolean isStaticWorkflow() {
        return this.workflow == Workflow.STATIC;
    }

    public final boolean isDynamicWorkflow() {
        return this.workflow == Workflow.DYNAMIC;
    }

    public final boolean isAOTWorkflow() {
        return this.workflow == Workflow.AOT;
    }

    private String logToFile(String logFile, String ... logTags) {
        StringBuilder sb = new StringBuilder("-Xlog:arguments");
        String prefix = ",";
        for (String tag : logTags) {
            sb.append(prefix);
            sb.append(tag);
        }
        sb.append(":file=" + logFile + "::filesize=0");
        return sb.toString();
    }

    private void listOutputFile(String file) {
        File f = new File(file);
        if (f.exists()) {
            System.out.println("[output file: " + file + " " + f.length() + " bytes]");
        } else {
            System.out.println("[output file: " + file + " does not exist]");
        }
    }

    private OutputAnalyzer executeAndCheck(String[] cmdLine, RunMode runMode, String ... logFiles) throws Exception {
        ProcessBuilder pb = ProcessTools.createTestJavaProcessBuilder(cmdLine);
        Process process = pb.start();
        OutputAnalyzer output = CDSTestUtils.executeAndLog(process, runMode.toString());
        for (String logFile : logFiles) {
            this.listOutputFile(logFile);
        }
        if (this.checkExitValue) {
            output.shouldHaveExitValue(0);
        }
        output.shouldNotContain("an object points to a static field that may hold a different value at runtime");
        CDSTestUtils.checkCommonExecExceptions(output);
        this.checkExecution(output, runMode);
        return output;
    }

    private String[] addCommonVMArgs(RunMode runMode, String[] cmdLine) {
        cmdLine = this.addClassOrModulePath(runMode, cmdLine);
        cmdLine = this.addWhiteBox(cmdLine);
        return cmdLine;
    }

    private String[] addClassOrModulePath(RunMode runMode, String[] cmdLine) {
        String cp = this.classpath(runMode);
        cmdLine = cp == null ? StringArrayUtils.concat(cmdLine, new String[]{"-Djava.class.path="}) : StringArrayUtils.concat(cmdLine, new String[]{"-cp", cp});
        String mp = this.modulepath(runMode);
        if (mp != null) {
            cmdLine = StringArrayUtils.concat(cmdLine, new String[]{"--module-path", mp});
        }
        return cmdLine;
    }

    private String[] addWhiteBox(String[] cmdLine) {
        if (this.whiteBoxJar != null) {
            cmdLine = StringArrayUtils.concat(cmdLine, new String[]{"-XX:+UnlockDiagnosticVMOptions", "-XX:+WhiteBoxAPI", "-Xbootclasspath/a:" + this.whiteBoxJar});
        }
        return cmdLine;
    }

    private OutputAnalyzer recordAOTConfiguration() throws Exception {
        RunMode runMode = RunMode.TRAINING;
        String[] cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-XX:AOTMode=record", "-XX:AOTConfiguration=" + this.aotConfigurationFile, this.logToFile(this.aotConfigurationFileLog, "class+load=debug", "aot=debug", "cds=debug", "cds+class=debug")});
        cmdLine = this.addCommonVMArgs(runMode, cmdLine);
        cmdLine = StringArrayUtils.concat(cmdLine, this.appCommandLine(runMode));
        return this.executeAndCheck(cmdLine, runMode, this.aotConfigurationFile, this.aotConfigurationFileLog);
    }

    private OutputAnalyzer createAOTCacheOneStep() throws Exception {
        RunMode runMode = RunMode.TRAINING;
        String[] cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-XX:AOTMode=record", "-XX:AOTCacheOutput=" + this.aotCacheFile, this.logToFile(this.aotCacheFileLog, "class+load=debug", "cds=debug", "cds+class=debug")});
        cmdLine = this.addCommonVMArgs(runMode, cmdLine);
        cmdLine = StringArrayUtils.concat(cmdLine, this.appCommandLine(runMode));
        OutputAnalyzer out = this.executeAndCheck(cmdLine, runMode, this.aotCacheFile, this.aotCacheFileLog);
        this.listOutputFile(this.aotCacheFileLog + ".0");
        return out;
    }

    private OutputAnalyzer createClassList() throws Exception {
        RunMode runMode = RunMode.TRAINING;
        String[] cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-Xshare:off", "-XX:DumpLoadedClassList=" + this.classListFile, this.logToFile(this.classListFileLog, "class+load=debug")});
        cmdLine = this.addCommonVMArgs(runMode, cmdLine);
        cmdLine = StringArrayUtils.concat(cmdLine, this.appCommandLine(runMode));
        return this.executeAndCheck(cmdLine, runMode, this.classListFile, this.classListFileLog);
    }

    private OutputAnalyzer dumpStaticArchive() throws Exception {
        RunMode runMode = RunMode.DUMP_STATIC;
        String[] cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-Xlog:aot", "-Xlog:aot+heap=error", "-Xlog:cds", "-Xshare:dump", "-XX:SharedArchiveFile=" + this.staticArchiveFile, "-XX:SharedClassListFile=" + this.classListFile, this.logToFile(this.staticArchiveFileLog, "aot=debug", "cds=debug", "cds+class=debug", "aot+heap=warning", "cds+resolve=debug")});
        cmdLine = this.addCommonVMArgs(runMode, cmdLine);
        cmdLine = StringArrayUtils.concat(cmdLine, this.appCommandLine(runMode));
        return this.executeAndCheck(cmdLine, runMode, this.staticArchiveFile, this.staticArchiveFileLog);
    }

    private OutputAnalyzer createAOTCache() throws Exception {
        RunMode runMode = RunMode.ASSEMBLY;
        String[] cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-Xlog:aot", "-Xlog:aot+heap=error", "-Xlog:cds", "-XX:AOTMode=create", "-XX:AOTConfiguration=" + this.aotConfigurationFile, "-XX:AOTCache=" + this.aotCacheFile, this.logToFile(this.aotCacheFileLog, "aot=debug", "cds=debug", "cds+class=debug", "aot+heap=warning", "cds+resolve=debug")});
        cmdLine = this.addCommonVMArgs(runMode, cmdLine);
        cmdLine = StringArrayUtils.concat(cmdLine, this.appCommandLine(runMode));
        return this.executeAndCheck(cmdLine, runMode, this.aotCacheFile, this.aotCacheFileLog);
    }

    private String getBaseArchiveForDynamicArchive() throws Exception {
        WhiteBox wb = WhiteBox.getWhiteBox();
        if (wb.isSharingEnabled()) {
            return null;
        }
        File f = new File(this.tempBaseArchiveFile);
        if (!f.exists()) {
            CDSOptions opts = new CDSOptions();
            opts.setArchiveName(this.tempBaseArchiveFile);
            opts.addSuffix("-Djava.class.path=");
            OutputAnalyzer out = CDSTestUtils.createArchive(opts);
            CDSTestUtils.checkBaseDump(out);
        }
        return this.tempBaseArchiveFile;
    }

    private OutputAnalyzer dumpDynamicArchive() throws Exception {
        RunMode runMode = RunMode.DUMP_DYNAMIC;
        String[] cmdLine = new String[]{};
        String baseArchive = this.getBaseArchiveForDynamicArchive();
        if (this.isDynamicWorkflow()) {
            cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-Xlog:aot", "-Xlog:cds", "-XX:ArchiveClassesAtExit=" + this.dynamicArchiveFile, this.logToFile(this.dynamicArchiveFileLog, "aot=debug", "cds=debug", "cds+class=debug", "cds+resolve=debug", "class+load=debug")});
            cmdLine = this.addCommonVMArgs(runMode, cmdLine);
        }
        if (baseArchive != null) {
            cmdLine = StringArrayUtils.concat(cmdLine, new String[]{"-XX:SharedArchiveFile=" + baseArchive});
        }
        cmdLine = StringArrayUtils.concat(cmdLine, this.appCommandLine(runMode));
        return this.executeAndCheck(cmdLine, runMode, this.dynamicArchiveFile, this.dynamicArchiveFileLog);
    }

    public OutputAnalyzer productionRun() throws Exception {
        return this.productionRun(null, null);
    }

    public OutputAnalyzer productionRun(String[] extraVmArgs) throws Exception {
        return this.productionRun(extraVmArgs, null);
    }

    public OutputAnalyzer productionRun(String[] extraVmArgs, String[] extraAppArgs) throws Exception {
        RunMode runMode = RunMode.PRODUCTION;
        String[] cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-XX:+UnlockDiagnosticVMOptions", "-XX:VerifyArchivedFields=2", this.logToFile(this.productionRunLog(), "aot", "cds")});
        cmdLine = this.addCommonVMArgs(runMode, cmdLine);
        if (this.isStaticWorkflow()) {
            cmdLine = StringArrayUtils.concat(cmdLine, new String[]{"-Xshare:on", "-XX:SharedArchiveFile=" + this.staticArchiveFile});
        } else if (this.isDynamicWorkflow()) {
            cmdLine = StringArrayUtils.concat(cmdLine, new String[]{"-Xshare:on", "-XX:SharedArchiveFile=" + this.dynamicArchiveFile});
        } else if (this.isAOTWorkflow()) {
            cmdLine = StringArrayUtils.concat(cmdLine, new String[]{"-XX:AOTMode=on", "-XX:AOTCache=" + this.aotCacheFile});
        }
        if (extraVmArgs != null) {
            cmdLine = StringArrayUtils.concat(cmdLine, extraVmArgs);
        }
        cmdLine = StringArrayUtils.concat(cmdLine, this.appCommandLine(runMode));
        if (extraAppArgs != null) {
            cmdLine = StringArrayUtils.concat(cmdLine, extraAppArgs);
        }
        OutputAnalyzer out = this.executeAndCheck(cmdLine, runMode, this.productionRunLog());
        ++this.numProductionRuns;
        return out;
    }

    public void run(String ... args) throws Exception {
        Object err = "Must have at least one command line argument of the following: ";
        String prefix = "";
        for (Workflow wf : Workflow.values()) {
            err = (String)err + prefix;
            err = (String)err + String.valueOf((Object)wf);
            prefix = ", ";
        }
        if (args.length < 1) {
            throw new RuntimeException((String)err);
        }
        if (args[0].equals("STATIC")) {
            this.runStaticWorkflow();
        } else if (args[0].equals("DYNAMIC")) {
            this.runDynamicWorkflow();
        } else if (args[0].equals("AOT")) {
            this.runAOTWorkflow(args);
        } else {
            throw new RuntimeException((String)err);
        }
    }

    public void runStaticWorkflow() throws Exception {
        this.workflow = Workflow.STATIC;
        this.createClassList();
        this.dumpStaticArchive();
        this.productionRun();
    }

    public void runDynamicWorkflow() throws Exception {
        this.workflow = Workflow.DYNAMIC;
        this.dumpDynamicArchive();
        this.productionRun();
    }

    public void runAOTWorkflow(String ... args) throws Exception {
        this.workflow = Workflow.AOT;
        boolean oneStepTraining = true;
        if (System.getProperty("CDSAppTester.two.step.training") != null) {
            oneStepTraining = false;
        }
        if (args.length > 1) {
            if (args[1].equals("--one-step-training")) {
                oneStepTraining = true;
            } else if (args[1].equals("--two-step-training")) {
                oneStepTraining = false;
            } else {
                throw new RuntimeException("Unknown option: " + args[1]);
            }
        }
        if (oneStepTraining) {
            try {
                this.inOneStepTraining = true;
                this.createAOTCacheOneStep();
            }
            finally {
                this.inOneStepTraining = false;
            }
        } else {
            this.recordAOTConfiguration();
            this.createAOTCache();
        }
        this.productionRun();
    }

    public void runAOTAssemblyWorkflow() throws Exception {
        this.workflow = Workflow.AOT;
        this.recordAOTConfiguration();
        this.createAOTCache();
    }

    public static enum RunMode {
        TRAINING,
        DUMP_STATIC,
        DUMP_DYNAMIC,
        ASSEMBLY,
        PRODUCTION;


        public boolean isStaticDump() {
            return this == DUMP_STATIC;
        }

        public boolean isProductionRun() {
            return this == PRODUCTION;
        }

        public boolean isApplicationExecuted() {
            return this != ASSEMBLY && this != DUMP_STATIC;
        }
    }

    private static enum Workflow {
        STATIC,
        DYNAMIC,
        AOT;

    }
}

