/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;

public class RoundedRectangleAnchor
extends ChopboxAnchor {
    private static final int LEFT = 1;
    private static final int MIDDLE = 2;
    private static final int RIGHT = 4;
    private static final int TOP = 8;
    private static final int CENTER = 16;
    private static final int BOTTOM = 32;
    private final Dimension dimension;

    public RoundedRectangleAnchor(RoundedRectangle figure) {
        super(figure);
        this.dimension = null;
    }

    public RoundedRectangleAnchor(Figure figure, Dimension corners) {
        super(figure);
        this.dimension = corners;
    }

    @Override
    public Point getLocation(Point ref) {
        Dimension corner = this.dimension;
        if (this.getOwner() instanceof RoundedRectangle) {
            corner = ((RoundedRectangle)this.getOwner()).getCornerDimensions();
        }
        Point location = super.getLocation(ref);
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getOwner().getBounds());
        r.translate(-1, -1);
        r.resize(1, 1);
        this.getOwner().translateToAbsolute(r);
        int yTop = r.y + corner.height / 2;
        int yBottom = r.y + r.height - corner.height / 2;
        int xLeft = r.x + corner.width / 2;
        int xRight = r.x + r.width - corner.width / 2;
        int pos = 0;
        pos = location.x < xLeft ? 1 : (location.x > xRight ? 4 : 2);
        pos = location.y < yTop ? (pos |= 8) : (location.y > yBottom ? (pos |= 0x20) : (pos += 16));
        return switch (pos) {
            case 10, 17, 20, 34 -> new Point(location.x, location.y);
            case 9 -> RoundedRectangleAnchor.ellipseAnchorGetLocation(location, new Rectangle(r.x, r.y, corner.width, corner.height), this.getOwner().getBounds().getCenter())[0];
            case 12 -> RoundedRectangleAnchor.ellipseAnchorGetLocation(location, new Rectangle(r.x + r.width - corner.width, r.y, corner.width, corner.height), this.getOwner().getBounds().getCenter())[1];
            case 18 -> new Point(r.x, r.y + r.height / 2);
            case 33 -> RoundedRectangleAnchor.ellipseAnchorGetLocation(location, new Rectangle(r.x, r.y + r.height - corner.height, corner.width, corner.height), this.getOwner().getBounds().getCenter())[0];
            case 36 -> RoundedRectangleAnchor.ellipseAnchorGetLocation(location, new Rectangle(r.x + r.width - corner.width, r.y + r.height - corner.height, corner.width, corner.height), this.getOwner().getBounds().getCenter())[1];
            default -> throw new IllegalStateException("Calculation of RoundedRectangleAnchor missed. Rect: " + String.valueOf(r) + " Point: " + String.valueOf(location));
        };
    }

    private static Point[] ellipseAnchorGetLocation(Point ref, Rectangle r, Point c) {
        double aSqr;
        double a;
        PrecisionPoint reference = new PrecisionPoint(r.getCenter().negate().translate(ref));
        PrecisionPoint center = new PrecisionPoint(r.getCenter().negate().translate(c));
        double referenceX = reference.preciseX() * 2.0 / (double)r.width;
        double referenceY = reference.preciseY() * 2.0 / (double)r.height;
        double centerX = center.preciseX() * 2.0 / (double)r.width;
        double centerY = center.preciseY() * 2.0 / (double)r.height;
        double b = centerY - centerX * (a = (referenceY - centerY) / (referenceX - centerX));
        double bSqr = Math.pow(b, 2.0);
        double xSqrt = Math.sqrt((1.0 - bSqr) / ((aSqr = Math.pow(a, 2.0)) + 1.0) + aSqr * bSqr / Math.pow(aSqr + 1.0, 2.0));
        if (xSqrt == Double.NaN) {
            return null;
        }
        double x1 = -xSqrt - a * b / (Math.pow(a, 2.0) + 1.0);
        double x2 = xSqrt - a * b / (Math.pow(a, 2.0) + 1.0);
        double y1 = a * x1 + b;
        double y2 = a * x2 + b;
        PrecisionPoint p1 = new PrecisionPoint(x1 * (double)r.width / 2.0, y1 * (double)r.height / 2.0);
        PrecisionPoint p2 = new PrecisionPoint(x2 * (double)r.width / 2.0, y2 * (double)r.height / 2.0);
        return new Point[]{r.getCenter().translate(p1), r.getCenter().translate(p2)};
    }
}

