/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.project;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.project.ResolverConfigurationIO;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.m2e.core.ui.internal.project.OutOfDateConfigurationDeltaVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenUpdateConfigurationChangeListener
implements IResourceChangeListener {
    private static Logger LOG = LoggerFactory.getLogger(MavenUpdateConfigurationChangeListener.class);

    public void resourceChanged(IResourceChangeEvent event) {
        List<IProject> outOfDateProjects;
        if (MavenUpdateConfigurationChangeListener.isAutoConfigurationUpdateDisabled()) {
            return;
        }
        try {
            OutOfDateConfigurationDeltaVisitor visitor = new OutOfDateConfigurationDeltaVisitor();
            event.getDelta().accept((IResourceDeltaVisitor)visitor);
            outOfDateProjects = visitor.outOfDateProjects;
        }
        catch (CoreException e) {
            LOG.error("An error occurred while checking for out-of-date configuration markers", (Throwable)e);
            return;
        }
        outOfDateProjects = outOfDateProjects.stream().filter(ResolverConfigurationIO::isAutomaticallyUpdateConfiguration).toList();
        this.updateProjectConfiguration(outOfDateProjects);
    }

    public static boolean isAutoConfigurationUpdateDisabled() {
        return !MavenPlugin.getMavenConfiguration().isAutomaticallyUpdateConfiguration();
    }

    protected void updateProjectConfiguration(List<IProject> outOfDateProjects) {
        if (outOfDateProjects != null && !outOfDateProjects.isEmpty()) {
            LOG.debug("Automatic update of {}", outOfDateProjects);
            new UpdateMavenProjectJob(outOfDateProjects).schedule();
        }
    }
}

