/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.server.core.RuntimeClasspathProviderDelegate;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.internal.ServerPlugin;

public class RuntimeClasspathProviderWrapper {
    private IConfigurationElement element;
    private volatile RuntimeClasspathProviderDelegate delegate;

    public RuntimeClasspathProviderWrapper(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getOrder() {
        try {
            String o = this.element.getAttribute("order");
            return Integer.parseInt(o);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String[] getRuntimeTypeIds() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.element.getAttribute("runtimeTypeIds"), ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (str == null || str.length() <= 0) continue;
                list.add(str.trim());
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }
        catch (Exception exception) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Could not parse runtime type ids: " + String.valueOf(this.element));
            }
            return null;
        }
    }

    public boolean supportsRuntimeType(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            return false;
        }
        return this.supportsRuntimeType(runtimeType.getId());
    }

    public boolean supportsRuntimeType(String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        String[] s = this.getRuntimeTypeIds();
        if (s == null) {
            return false;
        }
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            if (ss.endsWith("*") ? id.length() >= ss.length() && id.startsWith(ss.substring(0, ss.length() - 1)) : id.equals(ss)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeClasspathProviderDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                RuntimeClasspathProviderDelegate tempDelegate = (RuntimeClasspathProviderDelegate)this.element.createExecutableExtension("class");
                tempDelegate.initialize(this.getId());
                RuntimeClasspathProviderWrapper runtimeClasspathProviderWrapper = this;
                synchronized (runtimeClasspathProviderWrapper) {
                    if (this.delegate == null) {
                        this.delegate = tempDelegate;
                    }
                }
            }
            catch (Throwable t) {
                ServerPlugin.logExtensionFailure((String)this.toString(), (Throwable)t);
            }
        }
        return this.delegate;
    }

    public IClasspathEntry[] resolveClasspathContainerImpl(IProject project, IRuntime runtime) {
        if (runtime == null) {
            return null;
        }
        try {
            return this.getDelegate().resolveClasspathContainerImpl(project, runtime);
        }
        catch (Exception e) {
            ServerPlugin.logExtensionFailure((String)this.toString(), (Throwable)e);
            return null;
        }
    }

    public void requestClasspathContainerUpdate(IRuntime runtime, IClasspathEntry[] entries) {
        if (runtime == null) {
            return;
        }
        try {
            this.getDelegate().requestClasspathContainerUpdate(runtime, entries);
        }
        catch (Exception e) {
            ServerPlugin.logExtensionFailure((String)this.toString(), (Throwable)e);
        }
    }

    public boolean hasRuntimeClasspathChanged(IRuntime runtime) {
        if (runtime == null) {
            return false;
        }
        try {
            return this.getDelegate().hasRuntimeClasspathChanged(runtime);
        }
        catch (Exception e) {
            ServerPlugin.logExtensionFailure((String)this.toString(), (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return "RuntimeClasspathProviderWrapper[" + this.getId() + "]";
    }
}

