/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.RunnableJob;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ICompletionProposalProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ILinkedAsyncProposalListener;

public class LinkedAsyncProposalPositionGroup
extends LinkedProposalPositionGroup
implements ICompletionProposalProvider {
    private final RunnableFuture<LinkedProposalPositionGroup.Proposal[]> m_future;
    private final List<ILinkedAsyncProposalListener> m_listeners;

    public LinkedAsyncProposalPositionGroup(String groupId, RunnableFuture<LinkedProposalPositionGroup.Proposal[]> future) {
        super(groupId);
        this.m_future = (RunnableFuture)Ensure.notNull(future);
        this.m_listeners = new ArrayList<ILinkedAsyncProposalListener>();
    }

    @Override
    public synchronized void addListener(ILinkedAsyncProposalListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public LinkedProposalPositionGroup.Proposal[] getProposals() {
        try {
            return (LinkedProposalPositionGroup.Proposal[])this.m_future.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            SdkLog.debug((Object[])new Object[]{e});
            return new LinkedProposalPositionGroup.Proposal[]{new LinkedProposalPositionGroup.Proposal("Loading...", null, 10)};
        }
        catch (ExecutionException e) {
            throw new SdkException((Throwable)e);
        }
    }

    @Override
    public void load() {
        RunnableJob job = new RunnableJob("Load template proposals", this.m_future);
        job.setUser(false);
        job.setSystem(true);
        job.setPriority(10);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(this, (Job)job){
            final /* synthetic */ Job val$job;
            final /* synthetic */ LinkedAsyncProposalPositionGroup this$0;
            {
                this.val$job = job;
                this.this$0 = this$0;
            }

            public void done(IJobChangeEvent event) {
                this.val$job.removeJobChangeListener((IJobChangeListener)this);
                IStatus result = event.getResult();
                if (result.isOK()) {
                    this.fireLoaded();
                } else if (result.getSeverity() != 8) {
                    SdkLog.error((CharSequence)result.getMessage(), (Object[])new Object[]{result.getException()});
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fireLoaded() {
                ILinkedAsyncProposalListener[] iLinkedAsyncProposalListenerArray = this;
                synchronized (this) {
                    ILinkedAsyncProposalListener[] listeners = this.this$0.m_listeners.toArray(new ILinkedAsyncProposalListener[0]);
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    for (ILinkedAsyncProposalListener listener : listeners) {
                        listener.loaded();
                    }
                    return;
                }
            }
        });
        job.schedule();
    }
}

