/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.text.hover;

import com.ibm.icu.util.StringTokenizer;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.css.ui.internal.CSSUIPlugin;
import org.eclipse.wst.css.ui.internal.Logger;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class CSSColorNames {
    private static CSSColorNames instance;
    private static final Map colors;

    static {
        colors = new HashMap();
    }

    private CSSColorNames() {
        try {
            URL url = FileLocator.find((Bundle)CSSUIPlugin.getDefault().getBundle(), (IPath)new Path("csscolors/extended-color-mapping.xml"), null);
            XMLReader xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xmlReader.setContentHandler(new ColorMappingHandler());
            xmlReader.parse(new InputSource(url.openStream()));
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        catch (SAXException e) {
            Logger.logException(e);
        }
        catch (ParserConfigurationException e) {
            Logger.logException(e);
        }
    }

    public static synchronized CSSColorNames getInstance() {
        if (instance == null) {
            instance = new CSSColorNames();
        }
        return instance;
    }

    public RGB getRGB(String name) {
        return (RGB)colors.get(name);
    }

    class ColorMappingHandler
    extends DefaultHandler {
        private final String COLOR_ELEM = "color";
        private final String NAME_ATTR = "name";
        private final String RGB_ATTR = "rgb";

        ColorMappingHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("color".equals(qName)) {
                RGB rgbValue;
                String name = attributes.getValue("name");
                String rgb = attributes.getValue("rgb");
                if (name != null && rgb != null && (rgbValue = this.getRGB(rgb)) != null) {
                    colors.put(name, rgbValue);
                }
            }
        }

        private RGB getRGB(String rgb) {
            StringTokenizer tokenizer = new StringTokenizer(rgb, ",");
            int[] weights = new int[3];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                if (i > 2) {
                    return null;
                }
                try {
                    weights[i] = Integer.parseInt(tokenizer.nextToken().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (weights[i] > 255 || weights[i] < 0) {
                    return null;
                }
                ++i;
            }
            return new RGB(weights[0], weights[1], weights[2]);
        }
    }
}

