/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal.plugin;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class J2EENavigatorPlugin
extends AbstractUIPlugin {
    private static J2EENavigatorPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.jst.j2ee.navigator.ui";
    private static final String ICONS = "icons/";
    private ImageRegistry images;

    public J2EENavigatorPlugin() {
        plugin = this;
    }

    public static J2EENavigatorPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.images = new ImageRegistry(Display.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDescriptor getImageDescriptor(String relativePath) {
        ImageDescriptor descriptor = this.images.getDescriptor(relativePath);
        if (descriptor == null) {
            J2EENavigatorPlugin j2EENavigatorPlugin = this;
            synchronized (j2EENavigatorPlugin) {
                descriptor = this.images.getDescriptor(relativePath);
                if (descriptor == null) {
                    URL imageUrl = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(ICONS + relativePath), (Map)Collections.EMPTY_MAP);
                    descriptor = ImageDescriptor.createFromURL((URL)imageUrl);
                }
            }
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(ImageDescriptor descriptor) {
        Image image = this.images.get(descriptor.toString());
        if (image == null) {
            J2EENavigatorPlugin j2EENavigatorPlugin = this;
            synchronized (j2EENavigatorPlugin) {
                image = this.images.get(descriptor.toString());
                if (image == null) {
                    image = descriptor.createImage(true);
                    this.images.put(descriptor.toString(), image);
                }
            }
        }
        return image;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.images.dispose();
    }

    public static void logError(int aCode, String aMessage, Throwable anException) {
        J2EENavigatorPlugin.getDefault().getLog().log(J2EENavigatorPlugin.createErrorStatus(aCode, aMessage, anException));
    }

    public static void log(int severity, int aCode, String aMessage, Throwable exception) {
        J2EENavigatorPlugin.log(J2EENavigatorPlugin.createStatus(severity, aCode, aMessage, exception));
    }

    public static void log(IStatus aStatus) {
        J2EENavigatorPlugin.getDefault().getLog().log(aStatus);
    }

    public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage != null ? aMessage : "No message.", exception);
    }

    public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
        return J2EENavigatorPlugin.createStatus(4, aCode, aMessage, exception);
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return J2EENavigatorPlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EENavigatorPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(exception.getStatus());
    }
}

