/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.css.core.internal.document.CSSStructuredDocumentRegionContainer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSMediaRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.ui.internal.contentoutline.JFaceNodeAdapterFactoryCSS;
import org.eclipse.wst.css.ui.internal.contentoutline.RefreshStructureJob;
import org.eclipse.wst.css.ui.internal.image.CSSImageHelper;
import org.eclipse.wst.css.ui.internal.image.CSSImageType;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapterFactory;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.stylesheets.MediaList;

class CSSNodeAdapter
implements IJFaceNodeAdapter,
INodeAdapter,
Runnable {
    private static final boolean DEBUG = CSSNodeAdapter.getDebugValue();
    protected INodeAdapterFactory adapterFactory;
    private Vector notifyQueue;
    StyleViewUpdater lastUpdater;
    protected int delayMSecs = 500;
    RefreshStructureJob fRefreshJob = null;
    static final Class ADAPTER_KEY = IJFaceNodeAdapter.class;

    private static boolean getDebugValue() {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/outline");
        boolean result = value != null && value.equalsIgnoreCase("true");
        return result;
    }

    public CSSNodeAdapter(INodeAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    private synchronized RefreshStructureJob getRefreshJob() {
        if (this.fRefreshJob == null) {
            this.fRefreshJob = new RefreshStructureJob();
        }
        return this.fRefreshJob;
    }

    protected void internalActionPerformed() {
        if (this.notifyQueue == null) {
            return;
        }
        boolean refresh_all = false;
        boolean refresh_rule = false;
        int pos_all = 0;
        ArrayList<NotifyContext> targets = new ArrayList<NotifyContext>();
        int i = 0;
        while (i < this.notifyQueue.size()) {
            NotifyContext context = (NotifyContext)this.notifyQueue.get(i);
            if (context.notifier instanceof ICSSStyleSheet) {
                refresh_all = true;
                pos_all = i;
            }
            if (context.notifier instanceof ICSSStyleDeclaration) {
                refresh_rule = true;
                targets.add(context);
            }
            ++i;
        }
        if (refresh_all) {
            ((NotifyContext)this.notifyQueue.get(pos_all)).fire();
        } else if (refresh_rule) {
            Iterator i2 = targets.iterator();
            while (i2.hasNext()) {
                ((NotifyContext)i2.next()).fire();
            }
        } else {
            i = 0;
            while (i < this.notifyQueue.size()) {
                ((NotifyContext)this.notifyQueue.get(i)).fire();
                ++i;
            }
        }
        this.notifyQueue.clear();
    }

    public void internalNotifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        for (Object listener : ((IJFaceNodeAdapterFactory)this.adapterFactory).getListeners()) {
            if (listener instanceof StructuredViewer) {
                this.notifyChangedForStructuredViewer((StructuredViewer)listener, notifier, eventType, changedFeature, oldValue, newValue, pos);
                continue;
            }
            if (!(listener instanceof PropertySheetPage)) continue;
            this.notifyChangedForPropertySheetPage((PropertySheetPage)listener, notifier, eventType, changedFeature, oldValue, newValue, pos);
        }
    }

    private void notifyChangedForPropertySheetPage(PropertySheetPage page, INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (page.getControl() == null || page.getControl().isDisposed()) {
            return;
        }
        if (eventType == 1 || eventType == 2 || eventType == 3) {
            page.refresh();
        }
    }

    private void notifyChangedForStructuredViewer(StructuredViewer viewer, INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        ICSSNode temp;
        if (viewer.getControl() == null || viewer.getControl().isDisposed()) {
            return;
        }
        if (eventType == 1) {
            if (notifier instanceof ICSSStyleSheet) {
                ICSSNode iCSSNode = temp = changedFeature != null ? (ICSSNode)changedFeature : (ICSSNode)newValue;
                if (temp instanceof ICSSStyleRule) {
                    viewer.refresh();
                } else {
                    while (!(temp instanceof ICSSStyleRule) && (temp = temp.getParentNode()) != null) {
                    }
                    if (temp == null || temp instanceof ICSSStyleSheet) {
                        viewer.refresh();
                    } else {
                        viewer.refresh((Object)temp);
                    }
                }
            } else {
                temp = (ICSSNode)notifier;
                if (temp != null) {
                    temp = temp.getParentNode();
                }
                if (temp == null || temp instanceof ICSSStyleSheet) {
                    viewer.refresh();
                } else {
                    viewer.refresh((Object)temp);
                }
            }
        }
        if (eventType == 2) {
            if (notifier instanceof ICSSStyleSheet) {
                ICSSNode iCSSNode = temp = changedFeature != null ? (ICSSNode)changedFeature : (ICSSNode)newValue;
                if (temp instanceof ICSSStyleRule) {
                    viewer.refresh();
                } else {
                    while (!(temp instanceof ICSSStyleRule) && (temp = temp.getParentNode()) != null) {
                    }
                }
                if (temp == null || temp instanceof ICSSStyleSheet) {
                    viewer.refresh();
                } else {
                    viewer.refresh((Object)temp);
                }
            } else if (newValue != null && newValue instanceof ICSSStyleDeclItem) {
                viewer.refresh((Object)((ICSSNode)newValue).getParentNode());
            } else {
                temp = (ICSSNode)notifier;
                if (temp != null) {
                    temp = temp.getParentNode();
                }
                if (temp == null || temp instanceof ICSSStyleSheet) {
                    viewer.refresh();
                } else {
                    viewer.refresh((Object)temp);
                }
            }
        } else if (eventType == 3) {
            if (notifier instanceof ICSSStyleSheet) {
                ICSSNode iCSSNode = temp = changedFeature != null ? (ICSSNode)changedFeature : (ICSSNode)newValue;
                if (temp instanceof ICSSStyleRule) {
                    viewer.refresh();
                } else {
                    while (!(temp instanceof ICSSStyleRule) && (temp = temp.getParentNode()) != null) {
                    }
                    if (temp == null || temp instanceof ICSSStyleSheet) {
                        viewer.refresh();
                    } else {
                        viewer.refresh((Object)temp);
                    }
                }
            } else {
                temp = (ICSSNode)notifier;
                if (temp != null) {
                    temp = temp.getParentNode();
                }
                if (temp == null || temp instanceof ICSSStyleSheet) {
                    viewer.refresh();
                } else {
                    viewer.refresh((Object)temp);
                }
            }
        }
    }

    public void internalRefreshAll() {
        Collection listeners = ((JFaceNodeAdapterFactoryCSS)this.adapterFactory).getListeners();
        for (Object listener : listeners) {
            PropertySheetPage page;
            if (listener instanceof StructuredViewer) {
                StructuredViewer viewer = (StructuredViewer)listener;
                if (viewer.getControl() == null || viewer.getControl().isDisposed()) continue;
                viewer.refresh();
                continue;
            }
            if (!(listener instanceof PropertySheetPage) || (page = (PropertySheetPage)listener).getControl() == null || page.getControl().isDisposed()) continue;
            page.refresh();
        }
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(ADAPTER_KEY);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this.notifyQueue == null) {
            this.notifyQueue = new Vector();
        }
        if (notifier instanceof ICSSNode) {
            Collection listeners = ((JFaceNodeAdapterFactoryCSS)this.adapterFactory).getListeners();
            for (Object listener : listeners) {
                StructuredViewer structuredViewer;
                if (!(listener instanceof StructuredViewer) || eventType != 4 && eventType != 5 && eventType != 1 && eventType != 2 && eventType != 3) continue;
                if (DEBUG) {
                    System.out.println("JFaceNodeAdapter notified on event type > " + eventType);
                }
                if ((structuredViewer = (StructuredViewer)listener).getControl() == null) continue;
                this.getRefreshJob().refresh(structuredViewer, (ICSSNode)notifier);
            }
        }
    }

    Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    @Override
    public void run() {
        this.lastUpdater = new StyleViewUpdater();
        this.getDisplay().asyncExec((Runnable)this.lastUpdater);
    }

    public Object[] getChildren(Object object) {
        if (object instanceof ICSSNode) {
            ICSSNode node = (ICSSNode)object;
            short nodeType = node.getNodeType();
            if (nodeType == 1 || nodeType == 6 || nodeType == 5) {
                node = node.getFirstChild();
                while (node != null && !(node instanceof ICSSStyleDeclaration)) {
                    node.getNextSibling();
                }
            }
            ArrayList<ICSSNode> children = new ArrayList<ICSSNode>();
            ICSSNode child = node != null ? node.getFirstChild() : null;
            while (child != null) {
                if (!(child instanceof ICSSPrimitiveValue) && !(child instanceof MediaList)) {
                    children.add(child);
                }
                if (child instanceof INodeNotifier) {
                    ((INodeNotifier)child).getAdapterFor(IJFaceNodeAdapter.class);
                }
                child = child.getNextSibling();
            }
            return children.toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object object) {
        if (object instanceof ICSSModel) {
            ArrayList v = new ArrayList();
            this.addElements(object, v);
            Object[] elements = v.toArray();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof INodeNotifier) {
                    ((INodeNotifier)elements[i]).getAdapterFor(IJFaceNodeAdapter.class);
                }
                ++i;
            }
            return elements;
        }
        return new Object[0];
    }

    public Image getLabelImage(Object element) {
        if (element instanceof ICSSNode) {
            CSSImageHelper helper = CSSImageHelper.getInstance();
            return helper.getImage(CSSImageType.getImageType((ICSSNode)element));
        }
        return null;
    }

    public String getLabelText(Object element) {
        Object result = "";
        if (element instanceof ICSSNode) {
            switch (((ICSSNode)element).getNodeType()) {
                case 1: {
                    result = ((ICSSStyleRule)element).getSelectors().getString();
                    break;
                }
                case 5: {
                    result = "@font-face";
                    break;
                }
                case 3: {
                    result = ((CSSImportRule)element).getHref();
                    String mediaText = this.getMediaText((CSSImportRule)element);
                    if (mediaText == null || mediaText.length() <= 0) break;
                    result = (String)result + " (" + mediaText + ")";
                    break;
                }
                case 6: {
                    result = "@page";
                    break;
                }
                case 8: {
                    result = "properties";
                    break;
                }
                case 9: {
                    result = ((ICSSStyleDeclItem)element).getPropertyName();
                    break;
                }
                case 11: {
                    result = ((ICSSPrimitiveValue)element).getStringValue();
                    break;
                }
                case 4: {
                    result = "@media";
                    String mediaText = this.getMediaText((CSSRule)((ICSSMediaRule)element));
                    if (mediaText == null || mediaText.length() <= 0) break;
                    result = (String)result + " (" + mediaText + ")";
                    break;
                }
                case 2: {
                    result = "@charset";
                    break;
                }
                case 12: {
                    result = ((MediaList)element).getMediaText();
                    break;
                }
            }
        }
        return result;
    }

    public Object getParent(Object object) {
        if (object instanceof ICSSNode) {
            ICSSNode node = ((ICSSNode)object).getParentNode();
            if (node != null && node.getNodeType() == 8) {
                if (node instanceof INodeNotifier) {
                    ((INodeNotifier)node).getAdapterFor(IJFaceNodeAdapter.class);
                }
                node = node.getParentNode();
            }
            return node;
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof ICSSNode) {
            if (object instanceof INodeNotifier) {
                ((INodeNotifier)object).getAdapterFor(IJFaceNodeAdapter.class);
            }
            if (object instanceof ICSSStyleDeclItem) {
                return false;
            }
            if (((ICSSNode)object).hasChildNodes()) {
                ICSSNode child = ((ICSSNode)object).getFirstChild();
                while (child != null) {
                    String childText;
                    if (child instanceof CSSStructuredDocumentRegionContainer && (childText = ((CSSStructuredDocumentRegionContainer)child).getCssText()) != null && childText.length() > 0) {
                        return true;
                    }
                    child = child.getNextSibling();
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addElements(Object element, ArrayList v) {
        ICSSNode node;
        if (element instanceof ICSSModel) {
            ICSSModel model = (ICSSModel)element;
            ICSSDocument doc = model.getDocument();
            node = doc.getFirstChild();
        } else {
            if (!(element instanceof ICSSNode)) {
                return;
            }
            node = ((ICSSNode)element).getFirstChild();
        }
        while (node != null) {
            if (node instanceof CSSRule) {
                v.add(node);
            }
            node = node.getNextSibling();
        }
    }

    private String getMediaText(CSSRule rule) {
        String result = "";
        ICSSNode child = rule != null ? ((ICSSNode)rule).getFirstChild() : null;
        while (child != null) {
            if (child.getNodeType() == 12) {
                result = ((MediaList)child).getMediaText();
                break;
            }
            child = child.getNextSibling();
        }
        return result;
    }

    class NotifyContext {
        INodeNotifier notifier;
        int eventType;
        Object changedFeature;
        Object oldValue;
        Object newValue;
        int pos;

        NotifyContext(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            this.notifier = notifier;
            this.eventType = eventType;
            this.changedFeature = changedFeature;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.pos = pos;
        }

        void fire() {
            CSSNodeAdapter.this.internalNotifyChanged(this.notifier, this.eventType, this.changedFeature, this.oldValue, this.newValue, this.pos);
        }
    }

    class StyleViewUpdater
    implements Runnable {
        StyleViewUpdater() {
        }

        @Override
        public void run() {
            if (CSSNodeAdapter.this.lastUpdater == this) {
                CSSNodeAdapter.this.internalActionPerformed();
                CSSNodeAdapter.this.lastUpdater = null;
            }
        }
    }
}

