/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

public record BNDInstructions(String key, String instructions) {
    public static final String DEFAULT_INSTRUCTIONS = "Bundle-Name:           Bundle derived from maven artifact ${mvnGroupId}:${mvnArtifactId}:${mvnVersion}\nversion:               ${version_cleanup;${mvnVersion}}\nBundle-SymbolicName:   wrapped.${mvnGroupId}.${mvnArtifactId}\nBundle-Version:        ${version}\nImport-Package:        *;resolution:=optional\nExport-Package:        *;version=\"${version}\";-noimport:=true\nDynamicImport-Package: *\n";
    public static final BNDInstructions EMPTY = new BNDInstructions("", null);

    public BNDInstructions(String key, String instructions) {
        this.key = key;
        this.instructions = instructions == null ? null : instructions.strip();
    }

    public static Properties getDefaultInstructionProperties() {
        return BNDInstructions.asProperties(DEFAULT_INSTRUCTIONS);
    }

    public Properties asProperties() {
        return BNDInstructions.asProperties(this.instructions == null || this.instructions.isBlank() ? DEFAULT_INSTRUCTIONS : this.instructions);
    }

    private static Properties asProperties(String instructions) {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(instructions));
        }
        catch (IOException e) {
            throw new AssertionError("conversion to properties failed", e);
        }
        return properties;
    }

    public boolean isEmpty() {
        return this.instructions == null || this.instructions.isBlank();
    }
}

