/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.cm.attributevalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractCompCoreQueryFactory;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IXMLNodeContextResolver;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.WebPathType;

public class TemplateWebPathType
extends WebPathType
implements IPossibleValues {
    public List getPossibleValues() {
        IXMLNodeContextResolver resolver;
        IModelContext context = this.getModelContext();
        if (context != null && (resolver = IStructuredDocumentContextResolverFactory2.INSTANCE.getXMLNodeContextResolver(context)) != null && resolver.isAttribute()) {
            return this.createPossibleValues(resolver.getValue());
        }
        return Collections.EMPTY_LIST;
    }

    private List createPossibleValues(String attrValue) {
        String currentPathString = attrValue;
        ArrayList<PossibleValue> possibleValues = new ArrayList<PossibleValue>();
        if (currentPathString == null || "".equals(currentPathString.trim())) {
            currentPathString = "/";
        }
        Path currentPath = new Path(currentPathString);
        IContainer webRoot = this.getWebRoot();
        if (webRoot == null) {
            return possibleValues;
        }
        IResource deepestElement = this.findDeepestCommonElement((IPath)currentPath, webRoot);
        if (deepestElement == null) {
            return possibleValues;
        }
        if (deepestElement instanceof IContainer) {
            try {
                IResource[] iResourceArray = ((IContainer)deepestElement).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    if (child.exists()) {
                        IPath childPath = child.getProjectRelativePath();
                        int numLeadingSegments = webRoot.getProjectRelativePath().matchingFirstSegments(childPath);
                        childPath = childPath.removeFirstSegments(numLeadingSegments);
                        String pathName = null;
                        pathName = currentPath.isAbsolute() ? childPath.makeAbsolute().toString() : childPath.makeRelative().toString();
                        PossibleValue pv = new PossibleValue(pathName, pathName);
                        possibleValues.add(pv);
                    }
                    ++n2;
                }
            }
            catch (CoreException ce) {
                FaceletCorePlugin.log("While trying possible values", ce);
            }
        }
        return possibleValues;
    }

    private IResource findDeepestCommonElement(IPath currentPath, IContainer webRoot) {
        String[] segments = currentPath.segments();
        IResource deepestElement = null;
        if (segments != null) {
            Path longestSubPath = new Path("");
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                deepestElement = webRoot.findMember((IPath)(longestSubPath = longestSubPath.append(segment)));
                if (deepestElement == null) {
                    longestSubPath = longestSubPath.removeLastSegments(1);
                    break;
                }
                ++n2;
            }
            deepestElement = webRoot.findMember((IPath)longestSubPath);
            if (deepestElement == null) {
                deepestElement = webRoot;
            } else {
                int avoidInfiniteLoopCount = 0;
                while (avoidInfiniteLoopCount < 1000 && deepestElement != null && !(deepestElement instanceof IContainer)) {
                    deepestElement = deepestElement.getParent();
                }
                if (avoidInfiniteLoopCount == 1000) {
                    throw new IllegalStateException();
                }
            }
        }
        return deepestElement;
    }

    protected IContainer getWebRoot() {
        AbstractCompCoreQueryFactory compCoreQueryFactory;
        AbstractVirtualComponentQuery virtualComponentQuery;
        IProject project = this.getProject2();
        if (project != null && (virtualComponentQuery = (compCoreQueryFactory = FaceletCorePlugin.getDefault().getCompCoreQueryFactory()).createVirtualComponentQuery(project)) != null) {
            return virtualComponentQuery.getWebContentFolder(project).getUnderlyingFolder();
        }
        return null;
    }
}

