/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.directedit;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;

public class LabelCellEditorLocator
implements CellEditorLocator {
    private INamedEditPart namedEditPart;
    private Point cursorLocation;

    public LabelCellEditorLocator(INamedEditPart namedEditPart, Point cursorLocation) {
        this.namedEditPart = namedEditPart;
        this.cursorLocation = cursorLocation;
    }

    public void relocate(CellEditor celleditor) {
        Text text = (Text)celleditor.getControl();
        if (text.getBounds().x <= 0 && this.namedEditPart.getLabelFigure() != null) {
            Label label = this.namedEditPart.getLabelFigure();
            Rectangle boundingRect = label.getTextBounds();
            int delta = Math.abs(boundingRect.x - label.getParent().getBounds().x);
            label.getParent().translateToAbsolute((Translatable)boundingRect);
            org.eclipse.swt.graphics.Rectangle trim = text.computeTrim(0, 0, 0, 0);
            boundingRect.translate(trim.x, trim.y);
            boundingRect.height -= trim.y;
            boundingRect.width = label.getParent().getBounds().width - delta;
            text.setBounds(boundingRect.x, boundingRect.y, boundingRect.width, boundingRect.height);
            if (this.cursorLocation != null) {
                Point translatedPoint = new Point(this.cursorLocation.x - boundingRect.x, this.cursorLocation.y - boundingRect.y);
                text.setSelection(0, 0);
                int xCaret = text.getCaretLocation().x;
                int offset = text.getCaretPosition();
                while (xCaret < translatedPoint.x) {
                    text.setSelection(offset + 1, offset + 1);
                    xCaret = text.getCaretLocation().x;
                    int newOffset = text.getCaretPosition();
                    if (newOffset == offset) break;
                    ++offset;
                }
                text.setSelection(offset, offset);
            }
        }
    }
}

