/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.catalog.participants;

import java.util.Arrays;
import java.util.List;
import org.eclipse.lemminx.commons.config.ConfigurationItemEdit;
import org.eclipse.lemminx.commons.config.ConfigurationItemEditType;
import org.eclipse.lemminx.commons.config.ConfigurationItemValueKind;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensRequest;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLCatalogCodeLensParticipant
implements ICodeLensParticipant {
    private final ContentModelManager contentModelManager;

    public XMLCatalogCodeLensParticipant(ContentModelManager contentModelManager) {
        this.contentModelManager = contentModelManager;
    }

    @Override
    public void doCodeLens(ICodeLensRequest request, List<CodeLens> lenses, CancelChecker cancelChecker) {
        this.createRegisterCatalogLenses(request, lenses);
    }

    private void createRegisterCatalogLenses(ICodeLensRequest request, List<CodeLens> lenses) {
        DOMDocument document = request.getDocument();
        if (!DOMUtils.isCatalog(document)) {
            return;
        }
        String documentURI = this.contentModelManager.expandSystemId(document.getDocumentURI());
        Range range = XMLPositionUtility.selectRootStartTag(document);
        String[] catalogs = this.contentModelManager.getCatalogs();
        if (catalogs == null || !Arrays.asList(catalogs).contains(documentURI)) {
            ConfigurationItemEdit configurationItemEdit = new ConfigurationItemEdit("xml.catalogs", documentURI, ConfigurationItemEditType.Add, ConfigurationItemValueKind.File);
            Command command = new Command("Register Catalog", "xml.update.configuration", Arrays.asList(configurationItemEdit));
            lenses.add(new CodeLens(range, command, null));
        } else {
            ConfigurationItemEdit configurationItemEdit = new ConfigurationItemEdit("xml.catalogs", documentURI, ConfigurationItemEditType.Delete, ConfigurationItemValueKind.File);
            Command command = new Command("Unregister Catalog", "xml.update.configuration", Arrays.asList(configurationItemEdit));
            lenses.add(new CodeLens(range, command, null));
        }
    }
}

