/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.wst.css.core.internal.document.CSSDocumentImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelImpl;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSRegionContainer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNamedNodeMap;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;

class CSSAttrImpl
extends CSSRegionContainer
implements ICSSAttr {
    private String fName = null;
    private String fValue = null;
    private CSSNodeImpl ownerCSSNode = null;

    CSSAttrImpl(CSSAttrImpl that) {
        super(that);
        this.fName = that.fName;
        this.setValue(that.fValue);
    }

    CSSAttrImpl(String name) {
        this.fName = name;
    }

    @Override
    public ICSSNode cloneNode(boolean deep) {
        return new CSSAttrImpl(this);
    }

    @Override
    public ICSSNamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public short getNodeType() {
        return -1;
    }

    @Override
    public ICSSNode getOwnerCSSNode() {
        return this.ownerCSSNode;
    }

    @Override
    public String getValue() {
        return this.fValue;
    }

    protected boolean matchName(String name) {
        if (name == null) {
            return false;
        }
        if (this.fName == null) {
            return false;
        }
        return this.fName.equals(name);
    }

    protected void notifyValueChanged(String oldValue) {
        if (this.ownerCSSNode == null) {
            return;
        }
        CSSDocumentImpl doc = this.ownerCSSNode.getContainerDocument();
        if (doc == null) {
            return;
        }
        CSSModelImpl model = (CSSModelImpl)doc.getModel();
        if (model == null) {
            return;
        }
        model.valueChanged(this, oldValue);
        String value = this.getValue();
        this.ownerCSSNode.notify(1, this, oldValue, value, this.ownerCSSNode.getStartOffset());
    }

    protected void setName(String newName) {
        this.fName = newName;
    }

    protected void setOwnerCSSNode(CSSNodeImpl newOwnerCSSNode) {
        this.ownerCSSNode = newOwnerCSSNode;
    }

    @Override
    public void setValue(String newValue) {
        String oldValue = this.fValue;
        this.fValue = newValue;
        this.notifyValueChanged(oldValue);
    }
}

