/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.resources.ExclusionInstance;
import org.eclipse.cdt.core.resources.ExclusionType;
import org.eclipse.cdt.core.resources.RefreshExclusion;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIImages;
import org.eclipse.cdt.managedbuilder.ui.properties.RefreshPolicyExceptionDialog;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.internal.ide.misc.ContainerContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RefreshPolicyTab
extends AbstractCBuildPropertyTab {
    private final Image IMG_FOLDER = CDTSharedImages.getImage((String)"icons/obj16/fldr_obj.gif");
    private final Image IMG_FILE = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILE_OBJ);
    private final Image IMG_RESOURCE = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILE_FOLDER_OBJ);
    private final Image IMG_EXCEPTION = CDTSharedImages.getImage((String)"icons/obj16/error_obj.gif");
    private static final int IDX_ADD_RESOURCE = 0;
    private static final int IDX_ADD_EXCEPTION = 1;
    private static final int IDX_EDIT_EXCEPTION = 2;
    private static final int IDX_DELETE = 3;
    private TreeViewer fTree;
    private RefreshScopeManager fManager = RefreshScopeManager.getInstance();
    private IProject fProject;
    private ArrayList<_Entry> fSrc;
    private HashMap<String, HashMap<IResource, List<RefreshExclusion>>> fConfigurationToResourcesToExclusionsMap;

    private HashMap<IResource, List<RefreshExclusion>> getResourcesToExclusionsMap(String configName) {
        HashMap<Object, List<Object>> resourceMap = this.fConfigurationToResourcesToExclusionsMap.get(configName);
        if (resourceMap == null) {
            resourceMap = new HashMap();
            resourceMap.put((IResource)this.fProject, new ArrayList());
            this.fConfigurationToResourcesToExclusionsMap.put(configName, resourceMap);
        }
        return resourceMap;
    }

    private String getConfigName() {
        return this.getCfg().getName();
    }

    private HashMap<String, HashMap<IResource, List<RefreshExclusion>>> copyHashMap(HashMap<String, HashMap<IResource, List<RefreshExclusion>>> source) {
        HashMap<String, HashMap<IResource, List<RefreshExclusion>>> target = new HashMap<String, HashMap<IResource, List<RefreshExclusion>>>();
        if (source.isEmpty()) {
            return target;
        }
        for (String configName : source.keySet()) {
            HashMap<IResource, List<RefreshExclusion>> source_resourceMap = source.get(configName);
            HashMap target_resourceMap = new HashMap();
            for (IResource source_resource : source_resourceMap.keySet()) {
                List<RefreshExclusion> source_exclusions = source_resourceMap.get(source_resource);
                LinkedList<RefreshExclusion> target_exclusions = new LinkedList<RefreshExclusion>();
                for (RefreshExclusion exclusion : source_exclusions) {
                    RefreshExclusion target_exclusion = (RefreshExclusion)exclusion.clone();
                    target_exclusions.add(target_exclusion);
                }
                target_resourceMap.put(source_resource, target_exclusions);
            }
            target.put(configName, target_resourceMap);
        }
        return target;
    }

    private void loadInfo() {
        HashMap configMap = this.fManager.getConfigurationToResourcesMap(this.fProject);
        this.fConfigurationToResourcesToExclusionsMap = this.copyHashMap(configMap);
    }

    private List<RefreshExclusion> getExclusions(String configName, IResource resource) {
        HashMap<IResource, List<RefreshExclusion>> resourceMap = this.getResourcesToExclusionsMap(configName);
        List<RefreshExclusion> exclusions = resourceMap.get(resource);
        if (exclusions == null) {
            exclusions = new LinkedList<RefreshExclusion>();
            resourceMap.put(resource, exclusions);
        }
        return resourceMap.get(resource);
    }

    protected void createControls(Composite parent) {
        super.createControls(parent);
        this.fProject = this.page.getProject();
        this.loadInfo();
        this.initButtons(new String[]{Messages.RefreshPolicyTab_addResourceButtonLabel, Messages.RefreshPolicyTab_addExceptionButtonLabel, Messages.RefreshPolicyTab_editExceptionButtonLabel, Messages.RefreshPolicyTab_deleteButtonLabel}, 120);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        Label topLabel = new Label(this.usercomp, 0);
        topLabel.setText(Messages.RefreshPolicyTab_tabLabel);
        Group g1 = this.setupGroup(this.usercomp, Messages.RefreshPolicyTab_resourcesGroupLabel, 2, 1808);
        this.fSrc = new ArrayList();
        this.generateTreeContent();
        this.fTree = new TreeViewer((Composite)g1);
        this.fTree.getTree().setLayoutData((Object)new GridData(1808));
        this.fTree.getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.RefreshPolicyTab_resourcesTreeLabel;
            }
        });
        this.fTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof _Entry) {
                    return ((_Entry)parentElement).getChildren();
                }
                if (parentElement instanceof _Exception_Node) {
                    return ((_Exception_Node)parentElement).getChildren();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof _Entry) {
                    return ((_Entry)element).parent;
                }
                if (element instanceof _Exception_Node) {
                    return ((_Exception_Node)element).parent;
                }
                if (element instanceof _Exclusion_Instance) {
                    return ((_Exclusion_Instance)element).parent;
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof _Entry || element instanceof _Exception_Node;
            }

            public Object[] getElements(Object inputElement) {
                return RefreshPolicyTab.this.fSrc.toArray(new _Entry[RefreshPolicyTab.this.fSrc.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fTree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof _Exception_Node) {
                    return RefreshPolicyTab.this.IMG_EXCEPTION;
                }
                if (element instanceof _Entry) {
                    _Entry entry = (_Entry)element;
                    if (entry.isExclusion()) {
                        return RefreshPolicyTab.this.getImageForExclusionType(entry.exclusion.getExclusionType());
                    }
                    return RefreshPolicyTab.this.getImageForResource(entry.resourceToRefresh);
                }
                if (element instanceof _Exclusion_Instance) {
                    return RefreshPolicyTab.this.getImageForExclusionType(((_Exclusion_Instance)element).instance.getExclusionType());
                }
                return null;
            }
        });
        this.fTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object sel;
                ISelection selection = event.getSelection();
                if (selection instanceof TreeSelection && (sel = ((TreeSelection)selection).getFirstElement()) != null && sel instanceof _Exception_Node) {
                    RefreshPolicyTab.this.fTree.setSelection(null);
                }
                RefreshPolicyTab.this.updateButtons();
            }
        });
        this.fTree.setInput(this.fSrc);
        this.fTree.expandAll();
        this.updateButtons();
    }

    private Image getImageForResource(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return this.IMG_FILE;
            }
            case 2: 
            case 4: {
                return this.IMG_FOLDER;
            }
        }
        return this.IMG_RESOURCE;
    }

    private Image getImageForExclusionType(ExclusionType exclusionType) {
        switch (exclusionType) {
            case FILE: {
                return this.IMG_FILE;
            }
            case FOLDER: {
                return this.IMG_FOLDER;
            }
        }
        return this.IMG_RESOURCE;
    }

    private void generateTreeContent() {
        Iterator<IResource> iterator = this.getResourcesToExclusionsMap(this.getConfigName()).keySet().iterator();
        while (iterator.hasNext()) {
            _Entry top = new _Entry(iterator.next());
            this.fSrc.add(top);
        }
    }

    private void clearTreeContent() {
        this.fSrc.clear();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.performOK();
    }

    protected void performDefaults() {
    }

    protected void updateData(ICResourceDescription cfg) {
        if (this.page.isMultiCfg()) {
            this.setAllVisible(false, null);
            return;
        }
        this.setAllVisible(true, null);
        this.clearTreeContent();
        this.generateTreeContent();
        this.fTree.refresh();
        this.fTree.expandAll();
    }

    public boolean canSupportMultiCfg() {
        return false;
    }

    protected void updateButtons() {
        TreeItem[] sel = this.fTree.getTree().getSelection();
        this.buttonSetEnabled(0, true);
        this.buttonSetEnabled(1, sel.length == 1 && sel[0].getData() instanceof _Entry);
        this.buttonSetEnabled(2, sel.length == 1 && sel[0].getData() instanceof _Entry && ((_Entry)sel[0].getData()).isExclusion());
        this.buttonSetEnabled(3, sel.length == 1 && (sel[0].getData() instanceof _Entry || sel[0].getData() instanceof _Exclusion_Instance));
    }

    protected void buttonPressed(int x) {
        Shell shell = this.usercomp.getShell();
        TreeSelection selection = (TreeSelection)this.fTree.getSelection();
        switch (x) {
            case 0: {
                CheckedTreeSelectionDialog addResourceDialog = new CheckedTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new FilteredContainerContentProvider());
                addResourceDialog.setInput((Object)ResourcesPlugin.getWorkspace());
                addResourceDialog.setTitle(Messages.RefreshPolicyTab_addResourceDialogTitle);
                addResourceDialog.setMessage(Messages.RefreshPolicyTab_addResourceDialogDescription);
                if (addResourceDialog.open() != 0) break;
                Object[] result = addResourceDialog.getResult();
                int i = 0;
                while (i < result.length) {
                    IResource resource = (IResource)result[i];
                    _Entry newResource = new _Entry(resource);
                    this.getResourcesToExclusionsMap(this.getConfigName()).put(resource, new LinkedList());
                    this.fSrc.add(newResource);
                    ++i;
                }
                this.fTree.refresh();
                this.fTree.expandAll();
                break;
            }
            case 1: {
                if (selection == null) break;
                _Entry sel = (_Entry)selection.getFirstElement();
                RefreshPolicyExceptionDialog addExceptionDialog = sel.isExclusion() ? new RefreshPolicyExceptionDialog(shell, sel.exclusion, true) : new RefreshPolicyExceptionDialog(shell, sel.resourceToRefresh, this.getExclusions(this.getConfigName(), sel.resourceToRefresh), true);
                if (addExceptionDialog.open() == 0) {
                    RefreshExclusion newExclusion = addExceptionDialog.getResult();
                    if (newExclusion != null) {
                        sel.addException(newExclusion);
                    }
                    this.fTree.refresh();
                    this.fTree.expandAll();
                }
                this.fTree.refresh();
                this.fTree.expandAll();
                break;
            }
            case 2: {
                if (selection == null) break;
                _Entry selectedExclusion = (_Entry)selection.getFirstElement();
                RefreshPolicyExceptionDialog editExceptionDialog = new RefreshPolicyExceptionDialog(shell, selectedExclusion.exclusion, false);
                if (editExceptionDialog.open() == 0) {
                    RefreshExclusion updatedExclusion = editExceptionDialog.getResult();
                    selectedExclusion.updateException(updatedExclusion);
                    this.fTree.refresh();
                    this.fTree.expandAll();
                }
                this.fTree.refresh();
                this.fTree.expandAll();
                break;
            }
            case 3: {
                if (selection == null) break;
                if (selection.getFirstElement() instanceof _Entry) {
                    _Entry sel1 = (_Entry)selection.getFirstElement();
                    boolean remove = false;
                    if (sel1.exceptions_node != null) {
                        String question = sel1.isExclusion() ? Messages.RefreshPolicyTab_deleteConfirmationDialog_question_exception : Messages.RefreshPolicyTab_deleteConfirmationDialog_question_resource;
                        if (MessageDialog.openQuestion((Shell)shell, (String)Messages.RefreshPolicyTab_deleteConfirmationDialog_title, (String)question)) {
                            remove = true;
                        }
                    } else {
                        remove = true;
                    }
                    if (!remove) break;
                    sel1.remove();
                    this.fTree.refresh();
                    this.fTree.expandAll();
                    break;
                }
                _Exclusion_Instance sel1 = (_Exclusion_Instance)selection.getFirstElement();
                boolean remove = false;
                if (sel1.parent.exclusion.supportsExclusionInstances() && sel1.parent.exclusion_instances.size() == 1 && sel1.parent.exceptions_node != null) {
                    if (MessageDialog.openQuestion((Shell)shell, (String)Messages.RefreshPolicyTab_deleteConfirmationDialog_title, (String)Messages.RefreshPolicyTab_deleteConfirmationDialog_question_exception)) {
                        remove = true;
                    }
                } else {
                    remove = true;
                }
                if (!remove) break;
                sel1.remove();
                this.fTree.refresh();
                this.fTree.expandAll();
                break;
            }
        }
    }

    protected void performOK() {
        for (String configName : this.fConfigurationToResourcesToExclusionsMap.keySet()) {
            this.fManager.setResourcesToExclusionsMap(this.fProject, configName, this.getResourcesToExclusionsMap(configName));
        }
        try {
            this.fManager.persistSettings(this.getResDesc().getConfiguration().getProjectDescription());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    class FilteredContainerContentProvider
    extends ContainerContentProvider {
        FilteredContainerContentProvider() {
        }

        public Object[] getChildren(Object element) {
            ArrayList<Object> filteredChildren = new ArrayList<Object>(Arrays.asList(super.getChildren(element)));
            Iterator<IResource> iterator = RefreshPolicyTab.this.getResourcesToExclusionsMap(RefreshPolicyTab.this.getConfigName()).keySet().iterator();
            while (iterator.hasNext()) {
                filteredChildren.remove(iterator.next());
            }
            return filteredChildren.toArray();
        }
    }

    class _Entry {
        IResource resourceToRefresh = null;
        RefreshExclusion exclusion = null;
        _Exception_Node parent = null;
        _Exception_Node exceptions_node = null;
        List<_Exclusion_Instance> exclusion_instances = new ArrayList<_Exclusion_Instance>();

        _Entry(IResource _ent) {
            this.resourceToRefresh = _ent;
            if (RefreshPolicyTab.this.getExclusions(RefreshPolicyTab.this.getConfigName(), this.resourceToRefresh) != null && RefreshPolicyTab.this.getExclusions(RefreshPolicyTab.this.getConfigName(), this.resourceToRefresh).size() > 0) {
                this.exceptions_node = new _Exception_Node(this);
            }
        }

        _Entry(RefreshExclusion _ent, _Exception_Node parent) {
            this.exclusion = _ent;
            this.parent = parent;
            if (this.exclusion.getNestedExclusions() != null && this.exclusion.getNestedExclusions().size() > 0) {
                this.exceptions_node = new _Exception_Node(this);
            }
            if (this.exclusion.getExclusionInstances() != null && this.exclusion.getExclusionInstances().size() > 0) {
                Iterator iterator = this.exclusion.getExclusionInstances().iterator();
                while (iterator.hasNext()) {
                    this.exclusion_instances.add(new _Exclusion_Instance((ExclusionInstance)iterator.next(), this));
                }
            }
        }

        public String toString() {
            if (this.isExclusion()) {
                return this.exclusion.getName();
            }
            return this.resourceToRefresh.getFullPath().makeRelative().toString();
        }

        public Object[] getChildren() {
            if (this.isExclusion()) {
                ArrayList<_Exclusion_Instance> children = new ArrayList<_Exclusion_Instance>(this.exclusion_instances);
                if (this.exceptions_node != null) {
                    children.add((_Exclusion_Instance)((Object)this.exceptions_node));
                }
                return children.toArray();
            }
            if (this.exceptions_node != null) {
                return new Object[]{this.exceptions_node};
            }
            return null;
        }

        public boolean isExclusion() {
            return this.parent != null;
        }

        public void addException(RefreshExclusion exclusion) {
            if (this.exceptions_node == null) {
                this.exceptions_node = new _Exception_Node(this);
            }
            this.exceptions_node.addException(exclusion);
        }

        public void updateException(RefreshExclusion exclusion) {
            List exclusionInstancesToAdd = exclusion.getExclusionInstances();
            Iterator iterator = exclusionInstancesToAdd.iterator();
            this.exclusion_instances.clear();
            while (iterator.hasNext()) {
                ExclusionInstance instanceToAdd = (ExclusionInstance)iterator.next();
                this.exclusion_instances.add(new _Exclusion_Instance(instanceToAdd, this));
            }
        }

        public void remove() {
            if (this.isExclusion()) {
                RefreshExclusion exclusionToRemove = this.exclusion;
                _Entry parentEntry = this.parent.parent;
                if (parentEntry.isExclusion()) {
                    parentEntry.exclusion.removeNestedExclusion(exclusionToRemove);
                } else {
                    List<RefreshExclusion> exceptions = RefreshPolicyTab.this.getExclusions(RefreshPolicyTab.this.getConfigName(), parentEntry.resourceToRefresh);
                    exceptions.remove(exclusionToRemove);
                }
                if (this.parent.exceptions.size() > 1) {
                    this.parent.exceptions.remove(this);
                } else {
                    parentEntry.exceptions_node = null;
                }
            } else {
                RefreshPolicyTab.this.getResourcesToExclusionsMap(RefreshPolicyTab.this.getConfigName()).remove(this.resourceToRefresh);
                RefreshPolicyTab.this.fSrc.remove(this);
            }
        }
    }

    class _Exception_Node {
        _Entry parent;
        List<_Entry> exceptions = new ArrayList<_Entry>();

        _Exception_Node(_Entry ent) {
            this.parent = ent;
            Iterator<Object> iterator = null;
            if (this.parent.isExclusion()) {
                if (this.parent.exclusion.getNestedExclusions() != null) {
                    iterator = this.parent.exclusion.getNestedExclusions().iterator();
                }
            } else if (RefreshPolicyTab.this.getExclusions(RefreshPolicyTab.this.getConfigName(), this.parent.resourceToRefresh) != null) {
                iterator = RefreshPolicyTab.this.getExclusions(RefreshPolicyTab.this.getConfigName(), this.parent.resourceToRefresh).iterator();
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    this.exceptions.add(new _Entry((RefreshExclusion)iterator.next(), this));
                }
            }
        }

        public void addException(RefreshExclusion exclusion) {
            this.exceptions.add(new _Entry(exclusion, this));
            if (this.parent.isExclusion()) {
                this.parent.exclusion.addNestedExclusion(exclusion);
            } else {
                List<RefreshExclusion> exclusions = RefreshPolicyTab.this.getExclusions(RefreshPolicyTab.this.getConfigName(), this.parent.resourceToRefresh);
                if (exclusions == null) {
                    exclusions = new LinkedList<RefreshExclusion>();
                    RefreshPolicyTab.this.getResourcesToExclusionsMap(RefreshPolicyTab.this.getConfigName()).put(this.parent.resourceToRefresh, exclusions);
                }
                exclusions.add(exclusion);
            }
        }

        public Object[] getChildren() {
            return this.exceptions.toArray();
        }

        public String toString() {
            return Messages.RefreshPolicyTab_exceptionsLabel;
        }
    }

    class _Exclusion_Instance {
        _Entry parent;
        ExclusionInstance instance = null;

        _Exclusion_Instance(ExclusionInstance instance, _Entry parent) {
            this.parent = parent;
            this.instance = instance;
        }

        public Object[] getChildren() {
            return null;
        }

        public String toString() {
            return this.instance.getDisplayString();
        }

        public void remove() {
            this.parent.exclusion.removeExclusionInstance(this.instance);
            this.parent.exclusion_instances.remove(this);
            if (this.parent.exclusion_instances.size() < 1 && this.parent.exclusion.supportsExclusionInstances()) {
                this.parent.remove();
            }
        }
    }
}

