/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;

public class ReviewAnnotationModel
implements IAnnotationModel {
    private final Set<IAnnotationModelListener> annotationModelListeners = new HashSet<IAnnotationModelListener>(2);
    private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();
    private ReviewBehavior behavior;
    private IDocument document;
    private final IDocumentListener documentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
        }
    };
    private final EContentAdapter modelAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            AnnotationModelEvent event;
            if (ReviewAnnotationModel.this.document == null) {
                return;
            }
            if (notification.getEventType() == 3) {
                event = new AnnotationModelEvent((IAnnotationModel)ReviewAnnotationModel.this);
                if (notification.getNewValue() instanceof IComment) {
                    ReviewAnnotationModel.this.createCommentAnnotations(ReviewAnnotationModel.this.document, event, (IComment)notification.getNewValue());
                }
                ReviewAnnotationModel.this.fireModelChanged(event);
            }
            if (notification.getEventType() == 4) {
                event = new AnnotationModelEvent((IAnnotationModel)ReviewAnnotationModel.this);
                if (notification.getOldValue() instanceof IComment) {
                    ReviewAnnotationModel.this.removeCommentAnnotations(ReviewAnnotationModel.this.document, event, (IComment)notification.getOldValue());
                }
                ReviewAnnotationModel.this.updateAnnotations();
            }
            if (notification.getEventType() == 1) {
                event = new AnnotationModelEvent((IAnnotationModel)ReviewAnnotationModel.this);
                if (notification.getNewValue() instanceof IComment) {
                    ReviewAnnotationModel.this.modifyCommentAnnotations(ReviewAnnotationModel.this.document, event, (IComment)notification.getOldValue(), (IComment)notification.getNewValue());
                }
                ReviewAnnotationModel.this.updateAnnotations();
            }
        }
    };
    private IReviewItem reviewItem;

    public void addAnnotation(Annotation annotation, Position position) {
    }

    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        if (this.annotationModelListeners.add(listener)) {
            this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this, true));
        }
    }

    public void connect(IDocument document) {
        this.document = document;
        this.connectItem();
        for (Annotation commentAnnotation : this.annotations) {
            try {
                if (!(commentAnnotation instanceof CommentAnnotation)) continue;
                document.addPosition(((CommentAnnotation)commentAnnotation).getPosition());
            }
            catch (BadLocationException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", e.getMessage(), (Throwable)e));
            }
        }
        document.addDocumentListener(this.documentListener);
        this.updateAnnotations();
    }

    public void disconnect(IDocument document) {
        for (Annotation commentAnnotation : this.annotations) {
            if (!(commentAnnotation instanceof CommentAnnotation)) continue;
            document.removePosition(((CommentAnnotation)commentAnnotation).getPosition());
        }
        document.removeDocumentListener(this.documentListener);
        this.disconnectItem();
        this.document = null;
    }

    public void disconnectItem() {
        if (this.reviewItem != null) {
            this.reviewItem.eAdapters().remove((Object)this.modelAdapter);
        }
        this.clear();
    }

    public Iterator<Annotation> getAnnotationIterator() {
        return this.annotations.iterator();
    }

    public List<CommentAnnotation> getAnnotationsForOffset(int offset) {
        ArrayList<CommentAnnotation> result = new ArrayList<CommentAnnotation>();
        for (CommentAnnotation annotation : this.annotations.stream().filter(CommentAnnotation.class::isInstance).map(CommentAnnotation.class::cast).collect(Collectors.toList())) {
            if (annotation.getPosition().offset > offset || annotation.getPosition().length + annotation.getPosition().offset < offset) continue;
            result.add(annotation);
        }
        return result;
    }

    public ReviewBehavior getBehavior() {
        return this.behavior;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public Annotation getFirstAnnotationForOffset(int offset) {
        for (CommentAnnotation annotation : this.annotations.stream().filter(CommentAnnotation.class::isInstance).map(CommentAnnotation.class::cast).collect(Collectors.toList())) {
            if (annotation.getPosition().offset > offset || annotation.getPosition().length + annotation.getPosition().offset < offset) continue;
            return annotation;
        }
        return null;
    }

    public IReviewItem getItem() {
        return this.reviewItem;
    }

    public Position getPosition(Annotation annotation) {
        if (annotation instanceof CommentAnnotation) {
            return ((CommentAnnotation)annotation).getPosition();
        }
        return null;
    }

    public void removeAnnotation(Annotation annotation) {
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        this.annotationModelListeners.remove(listener);
    }

    public void setItem(IReviewItem reviewItem, ReviewBehavior behavior) {
        this.disconnectItem();
        this.reviewItem = reviewItem;
        this.behavior = behavior;
        this.connectItem();
    }

    private void connectItem() {
        if (this.reviewItem != null) {
            this.reviewItem.eAdapters().add((Object)this.modelAdapter);
        }
    }

    private void createCommentAnnotations(IDocument document, AnnotationModelEvent event, IComment comment) {
        for (ILocation location : comment.getLocations()) {
            if (!(location instanceof ILineLocation)) continue;
            try {
                CommentAnnotation ca = this.createCommentAnnotation(document, comment, (ILineLocation)location);
                if (!this.annotations.add(ca)) continue;
                event.annotationAdded((Annotation)ca);
            }
            catch (BadLocationException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Unable to add annotation.", (Throwable)e));
            }
        }
    }

    private void removeCommentAnnotations(IDocument document, AnnotationModelEvent event, IComment comment) {
        for (ILocation location : comment.getLocations()) {
            if (!(location instanceof ILineLocation)) continue;
            try {
                CommentAnnotation ca = this.createCommentAnnotation(document, comment, (ILineLocation)location);
                this.annotations.remove((Object)ca);
                this.reviewItem.getComments().remove(comment);
                event.annotationRemoved((Annotation)ca);
            }
            catch (BadLocationException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Unable to remove annotation.", (Throwable)e));
            }
        }
    }

    private void modifyCommentAnnotations(IDocument document, AnnotationModelEvent event, IComment oldcomment, IComment comment) {
        for (ILocation location : comment.getLocations()) {
            if (!(location instanceof ILineLocation)) continue;
            try {
                CommentAnnotation oldCa = this.createCommentAnnotation(document, oldcomment, (ILineLocation)location);
                CommentAnnotation ca = new CommentAnnotation(oldCa.getPosition().offset, oldCa.getPosition().length, comment);
                this.annotations.remove((Object)oldCa);
                this.annotations.add(ca);
                event.annotationRemoved((Annotation)oldCa);
                event.annotationChanged((Annotation)ca);
            }
            catch (BadLocationException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Unable to modify annotation.", (Throwable)e));
            }
        }
    }

    private CommentAnnotation createCommentAnnotation(IDocument document, IComment comment, ILineLocation lineLocation) throws BadLocationException {
        int startLine = lineLocation.getRangeMin();
        int endLine = lineLocation.getRangeMax();
        int offset = 0;
        int length = 1;
        if (startLine != 0 && startLine <= document.getNumberOfLines()) {
            offset = document.getLineOffset(startLine - 1);
            if (endLine == 0) {
                endLine = startLine;
            }
            length = Math.max(document.getLineOffset(endLine - 1) - offset, 1);
        }
        return new CommentAnnotation(offset, length, comment);
    }

    protected void clear() {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        this.fireModelChanged(event);
    }

    protected void clear(AnnotationModelEvent event) {
        for (Annotation commentAnnotation : this.annotations) {
            if (!(commentAnnotation instanceof CommentAnnotation)) continue;
            event.annotationRemoved(commentAnnotation, ((CommentAnnotation)commentAnnotation).getPosition());
        }
        this.annotations.clear();
    }

    protected void fireModelChanged(AnnotationModelEvent event) {
        event.markSealed();
        if (!event.isEmpty()) {
            for (IAnnotationModelListener listener : this.annotationModelListeners) {
                if (listener instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)listener).modelChanged(event);
                    continue;
                }
                listener.modelChanged((IAnnotationModel)this);
            }
        }
    }

    protected void updateAnnotations() {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        if (this.document != null && this.reviewItem != null) {
            for (IComment comment : this.reviewItem.getComments()) {
                this.createCommentAnnotations(this.document, event, comment);
            }
        }
        this.fireModelChanged(event);
    }
}

