/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class ErrorDialogWithHelp
extends ErrorDialog {
    private String helpId;

    public ErrorDialogWithHelp(Shell parent, String title, String message, IStatus status, String helpId) {
        super(parent, title, message, status, -1);
        this.helpId = helpId;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.helpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, this.helpId);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return result;
    }

    protected Control createButtonBar(Composite parent) {
        if (this.helpId == null) {
            return super.createButtonBar(parent);
        }
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)composite);
        composite.setFont(parent.getFont());
        this.createHelpControl(composite);
        Control buttonSection = super.createButtonBar(composite);
        ((GridData)buttonSection.getLayoutData()).grabExcessHorizontalSpace = true;
        return composite;
    }

    private void createHelpControl(Composite parent) {
        Image helpImage = JFaceResources.getImage((String)"dialog_help_image");
        if (helpImage != null) {
            this.createHelpImageButton(parent, helpImage);
        } else {
            this.createHelpLink(parent);
        }
    }

    private void createHelpImageButton(Composite parent, Image image) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)toolBar);
        toolBar.setCursor(parent.getDisplay().getSystemCursor(21));
        ToolItem button = new ToolItem(toolBar, 8);
        button.setImage(image);
        button.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorDialogWithHelp.this.helpPressed();
            }
        });
    }

    private void createHelpLink(Composite parent) {
        Link link = new Link(parent, 524352);
        link.setLayoutData((Object)new GridData(64));
        link.setText("<a>" + IDialogConstants.HELP_LABEL + "</a>");
        link.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorDialogWithHelp.this.helpPressed();
            }
        });
    }

    private void helpPressed() {
        Control c = this.getShell().getDisplay().getFocusControl();
        while (c != null) {
            if (c.isListening(28)) {
                c.notifyListeners(28, new Event());
                break;
            }
            c = c.getParent();
        }
    }
}

