/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.text.MessageFormat;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.MergeStrategies;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.CherryPickCommand;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.TeamException;

public class CherryPickOperation
implements IEGitOperation {
    private final Repository repo;
    private final RevCommit commit;
    private int parentIndex = -1;
    private CherryPickResult result;

    public CherryPickOperation(Repository repository, RevCommit commit) {
        this.repo = repository;
        this.commit = commit;
    }

    public void setMainlineIndex(int parentIndex) {
        if (parentIndex >= 0 && parentIndex < this.commit.getParentCount()) {
            this.parentIndex = parentIndex;
        }
    }

    public CherryPickResult getResult() {
        return this.result;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)2);
                progress.subTask(MessageFormat.format(CoreText.CherryPickOperation_cherryPicking, CherryPickOperation.this.commit.name()));
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (Git git = new Git(CherryPickOperation.this.repo);){
                        CherryPickCommand command = git.cherryPick().include((AnyObjectId)CherryPickOperation.this.commit.getId());
                        MergeStrategy strategy = MergeStrategies.getPreferredMergeStrategy();
                        if (strategy != null) {
                            command.setStrategy(strategy);
                        }
                        if (CherryPickOperation.this.parentIndex >= 0 && CherryPickOperation.this.parentIndex < CherryPickOperation.this.commit.getParentCount()) {
                            command.setMainlineParentNumber(CherryPickOperation.this.parentIndex + 1);
                        }
                        CherryPickOperation.this.result = command.call();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (GitAPIException e) {
                    throw new TeamException(e.getLocalizedMessage(), e.getCause());
                }
                progress.worked(1);
                ProjectUtil.refreshValidProjects(ProjectUtil.getValidOpenProjects(CherryPickOperation.this.repo), (IProgressMonitor)progress.newChild(1));
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, m);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repo);
    }
}

