/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IModelEvolutionSupport;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.StatementBatcher;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public final class ModelEvolutionContext
implements IModelEvolutionSupport.Context {
    private final IRegistry<String, Object> properties = new HashMapRegistry.AutoCommit();
    private final IModelEvolutionSupport modelEvolutionSupport;
    private final long timeStamp;
    private final List<IModelEvolutionSupport.Model> models;
    private final List<IModelEvolutionSupport.Model> changedModels;
    private final Map<String, EPackage> storedPackages = new HashMap<String, EPackage>();
    private final EMFUtil.TreeMapping<EObject> elementMappings = new EMFUtil.TreeMapping(EObject.class);
    private final Map<EEnum, Map<Integer, Integer>> enumLiteralChanges = new HashMap<EEnum, Map<Integer, Integer>>();
    private final AtomicInteger totalUpdateCount = new AtomicInteger();

    public ModelEvolutionContext(IModelEvolutionSupport modelEvolutionSupport, List<IModelEvolutionSupport.Model> models, List<IModelEvolutionSupport.Model> changedModels) {
        this.modelEvolutionSupport = modelEvolutionSupport;
        this.models = models;
        this.changedModels = changedModels;
        this.timeStamp = this.getStore().getRepository().getTimeStamp();
        models.forEach(model -> {
            EPackage storedPackage = model.getStoredPackage();
            EMFUtil.getAllPackages((EPackage)storedPackage, ePackage -> {
                EPackage ePackage2 = this.storedPackages.put(ePackage.getNsURI(), (EPackage)ePackage);
            });
            this.elementMappings.map((EObject)storedPackage, (EObject)model.getRegisteredPackage(), true);
        });
    }

    public IRegistry<String, Object> properties() {
        return this.properties;
    }

    @Override
    public void log(Object message) {
        if (message != null) {
            OM.LOG.info(message.toString());
        }
    }

    @Override
    public IModelEvolutionSupport getModelEvolutionSupport() {
        return this.modelEvolutionSupport;
    }

    @Override
    public IDBStore getStore() {
        return this.modelEvolutionSupport.getStore();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getTotalUpdateCount() {
        return this.totalUpdateCount.get();
    }

    @Override
    public StatementBatcher createStatementBatcher(Connection connection) throws SQLException {
        StatementBatcher batcher = new StatementBatcher(connection);
        batcher.addListener(event -> {
            if (event instanceof StatementBatcher.BatchEvent || event instanceof StatementBatcher.ResultEvent) {
                this.log(event);
            } else if (event instanceof StatementBatcher.CloseEvent) {
                this.totalUpdateCount.addAndGet(batcher.getTotalUpdateCount());
            }
        });
        return batcher;
    }

    @Override
    public List<IModelEvolutionSupport.Model> getModels() {
        return this.models;
    }

    @Override
    public List<IModelEvolutionSupport.Model> getChangedModels() {
        return this.changedModels;
    }

    @Override
    public Map<String, EPackage> getStoredPackages() {
        return this.storedPackages;
    }

    @Override
    public EMFUtil.TreeMapping<EObject> getElementMappings() {
        return this.elementMappings;
    }

    @Override
    public <T extends EObject> T getRegisteredElement(T storedElement) {
        EObject registeredElement = (EObject)this.elementMappings.get(storedElement);
        return (T)registeredElement;
    }

    @Override
    public Map<Integer, Integer> getEnumLiteralChanges(EEnum storedEnum) {
        return this.enumLiteralChanges.computeIfAbsent(storedEnum, k -> {
            HashMap changes = new HashMap();
            EEnum registeredEnum = (EEnum)this.elementMappings.get((Object)storedEnum);
            if (registeredEnum != null) {
                storedEnum.getELiterals().forEach(storedLiteral -> {
                    int registeredLiteralID;
                    int storedLiteralID;
                    EEnumLiteral registeredLiteral = (EEnumLiteral)this.elementMappings.get(storedLiteral);
                    if (registeredLiteral != null && (storedLiteralID = storedLiteral.getValue()) != (registeredLiteralID = registeredLiteral.getValue())) {
                        changes.put(storedLiteralID, registeredLiteralID);
                    }
                });
            }
            return changes;
        });
    }

    @Override
    public <F extends EStructuralFeature> void handleFeatureIDChanges(EClass storedClass, Function<EClass, Collection<F>> featureProvider, BiConsumer<Integer, Integer> handler) {
        Collection<F> features;
        EClass registeredClass;
        if (handler != null && (registeredClass = (EClass)this.elementMappings.get((Object)storedClass)) != null && (features = featureProvider.apply(storedClass)) != null) {
            features.forEach(storedFeature -> {
                int registeredFeatureID;
                int storedFeatureID;
                EStructuralFeature registeredFeature = (EStructuralFeature)this.elementMappings.get(storedFeature);
                if (registeredFeature != null && (storedFeatureID = storedClass.getFeatureID(storedFeature)) != (registeredFeatureID = registeredClass.getFeatureID(registeredFeature))) {
                    handler.accept(storedFeatureID, registeredFeatureID);
                }
            });
        }
    }
}

