/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.layoutoption;

import java.util.Collections;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithm;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public final class LayoutOptionPropertiesUtils {
    public static final String DELETE_OPTION_IMAGE_NAME = "Delete_16x16.gif";
    public static final String ADD_OPTION_IMAGE_NAME = "Add_16x16.gif";

    private LayoutOptionPropertiesUtils() {
    }

    public static CLabel createHelpLabel(TabbedPropertySheetWidgetFactory widgetFactory, Composite parentComposite, Control topControl, Control leftControl, Image helpIcon, LayoutOption layoutOption) {
        CLabel help = widgetFactory.createCLabel(parentComposite, "");
        FormData data = new FormData();
        data.top = new FormAttachment(topControl, 0, 0x1000000);
        data.left = new FormAttachment(leftControl);
        help.setLayoutData((Object)data);
        help.setImage(helpIcon);
        String description = LayoutOptionPropertiesUtils.getDescription((CustomLayoutConfiguration)layoutOption.eContainer(), layoutOption);
        if (description == null) {
            description = "";
        }
        help.setToolTipText(description);
        return help;
    }

    public static Button createRemoveOptionButton(Control valueComposite, Composite containerComposite, ViewpointPropertySheetPage viewpointPropertySheetPage, TabbedPropertySheetWidgetFactory widgetFactory, LayoutOption layoutOption) {
        Image removeImage = ExtendedImageRegistry.INSTANCE.getImage(DiagramUIPlugin.getPlugin().getImage(DELETE_OPTION_IMAGE_NAME));
        Button removeOverrideButton = widgetFactory.createButton(containerComposite, "", 8);
        FormData data = new FormData();
        data.left = new FormAttachment(valueComposite, 5);
        data.top = new FormAttachment(valueComposite, 0, 0x1000000);
        removeOverrideButton.setLayoutData((Object)data);
        removeOverrideButton.setImage(removeImage);
        removeOverrideButton.addSelectionListener(LayoutOptionPropertiesUtils.createRemoveOptionButtonListener(layoutOption, viewpointPropertySheetPage.getEditor().getEditingDomain(), (TabbedPropertySheetPage)viewpointPropertySheetPage));
        return removeOverrideButton;
    }

    private static SelectionListener createRemoveOptionButtonListener(final LayoutOption layoutOption, final EditingDomain editingDomain, final TabbedPropertySheetPage tabbedPropertySheetPage) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)layoutOption.eContainer(), (Object)DescriptionPackage.eINSTANCE.getCustomLayoutConfiguration_LayoutOptions(), Collections.singletonList(layoutOption)));
                Display.getCurrent().asyncExec(() -> tabbedPropertySheetPage.refresh());
            }
        };
    }

    public static String getDescription(CustomLayoutConfiguration customLayoutConfiguration, LayoutOption layoutOption) {
        LayoutOption registerdedlayoutOption;
        CustomLayoutAlgorithm customLayoutAlgorithm = (CustomLayoutAlgorithm)DiagramUIPlugin.getPlugin().getLayoutAlgorithms().get(customLayoutConfiguration.getId());
        if (customLayoutAlgorithm != null && (registerdedlayoutOption = (LayoutOption)customLayoutAlgorithm.getLayoutOptions().get(layoutOption.getId())).getDescription() != null) {
            return registerdedlayoutOption.getDescription();
        }
        return "";
    }

    public static String getLabel(CustomLayoutConfiguration customLayoutConfiguration, LayoutOption layoutOption) {
        LayoutOption registerdedlayoutOption;
        CustomLayoutAlgorithm customLayoutAlgorithm = (CustomLayoutAlgorithm)DiagramUIPlugin.getPlugin().getLayoutAlgorithms().get(customLayoutConfiguration.getId());
        if (customLayoutAlgorithm != null && (registerdedlayoutOption = (LayoutOption)customLayoutAlgorithm.getLayoutOptions().get(layoutOption.getId())).getDescription() != null) {
            return registerdedlayoutOption.getLabel();
        }
        return "";
    }
}

