/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Predicate;
import java.util.Objects;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;

public class NotationPredicate
implements Predicate<View> {
    private final EClass viewType;
    private final int visualId;
    private final Predicate<DDiagramElement> viewpointElementPredicate;

    public NotationPredicate(EClass viewType, int visualId, Predicate<DDiagramElement> viewpointElementPredicate) {
        this.viewType = Objects.requireNonNull(viewType);
        this.visualId = visualId;
        this.viewpointElementPredicate = Objects.requireNonNull(viewpointElementPredicate);
    }

    public boolean apply(View input) {
        if (this.viewType.isInstance((Object)input) && this.viewHasType(input, this.visualId)) {
            EObject element = input.getElement();
            return element instanceof DDiagramElement && this.viewpointElementPredicate.apply((Object)((DDiagramElement)element));
        }
        return false;
    }

    private boolean viewHasType(View view, int type) {
        return view.getType().equals(Integer.toString(type));
    }
}

