/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.AbstractDiagramAction;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.BorderItemAwareLayoutProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class ArrangeBorderNodesAction
extends AbstractDiagramAction {
    private String textSelection = new String();
    private String textDiagram = new String();

    protected ArrangeBorderNodesAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected ArrangeBorderNodesAction(IWorkbenchPart workbenchpart) {
        super(workbenchpart);
    }

    protected void initAction(String id, String newTextSelection, String newTextDiagram) {
        this.textSelection = newTextSelection;
        this.textDiagram = newTextDiagram;
        this.setId(id);
        this.setText(this.textSelection);
        this.setToolTipText(Messages.ArrangeBorderNodesAction_toolTipText);
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/arrangeBorderedNodes.gif"));
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() > 0 && super.canEditInstance();
    }

    protected void internalRefresh() {
        super.internalRefresh();
        if (this.isDiagramSelection(this.getSelectedEditPart())) {
            this.setText(this.textDiagram);
            this.setToolTipText(Messages.ArrangeBorderNodesAction_toolTipDiagramText);
        } else {
            this.setText(this.textSelection);
            this.setToolTipText(Messages.ArrangeBorderNodesAction_toolTipText);
        }
    }

    private List<EditPart> getSelectedEditPart() {
        List selection = this.getSelectedObjects();
        return selection.stream().filter(EditPart.class::isInstance).map(EditPart.class::cast).toList();
    }

    private boolean isDiagramSelection(List<EditPart> selection) {
        return selection.stream().allMatch(DDiagramEditPart.class::isInstance);
    }

    protected Command getCommand() {
        List<EditPart> selectedEditPart = this.getSelectedEditPart();
        if (selectedEditPart.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        boolean recursive = this.isDiagramSelection(selectedEditPart);
        BorderItemAwareLayoutProvider layoutProvider = new BorderItemAwareLayoutProvider(null, recursive);
        return layoutProvider.layoutEditParts(selectedEditPart, (IAdaptable)new ObjectAdapter((Object)"DEFAULT"), false);
    }

    protected String getCommandLabel() {
        return Messages.ArrangeBorderNodesAction_commandLabel;
    }

    public static ArrangeBorderNodesAction createArrangeBorderNodesAction(IWorkbenchPage workbenchPage) {
        ArrangeBorderNodesAction action = new ArrangeBorderNodesAction(workbenchPage);
        action.initAction("arrangeBorderNodesAction", Messages.ArrangeBorderNodesAction_actionText, Messages.ArrangeBorderNodesAction_actionDiagramText);
        return action;
    }

    public static ArrangeBorderNodesAction createToolBarArrangeBorderNodesAction(IWorkbenchPage workbenchPage) {
        ArrangeBorderNodesAction action = new ArrangeBorderNodesAction(workbenchPage);
        action.initAction("arrangeBorderNodesActionToolBar", Messages.ArrangeBorderNodesAction_toolbarActionText, Messages.ArrangeBorderNodesAction_toolbarActionDiagramText);
        return action;
    }
}

