/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.service;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.inject.TargetType;
import org.osgi.test.common.list.ListSupplierDelegate;
import org.osgi.test.common.service.ServiceAware;
import org.osgi.test.common.service.ServiceConfiguration;
import org.osgi.test.common.service.ServiceConfigurationKey;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.inject.InjectingExtension;

public class ServiceExtension
extends InjectingExtension<InjectService> {
    public ServiceExtension() {
        super(InjectService.class, new Class[0]);
    }

    @Override
    protected boolean supportsType(TargetType targetType, ExtensionContext extensionContext) {
        return true;
    }

    private Type extractServiceType(TargetType targetType, InjectService injectService) throws ParameterResolutionException {
        WildcardType wild;
        Object valueType;
        Class<Object> upperBoundType = null;
        if (targetType.matches(List.class) || targetType.matches(ServiceAware.class)) {
            if (targetType.hasParameterizedTypes()) {
                valueType = (Type)targetType.getFirstGenericTypes().get();
                if (valueType instanceof WildcardType) {
                    WildcardType wild2 = (WildcardType)valueType;
                    upperBoundType = wild2.getUpperBounds().length > 0 ? wild2.getUpperBounds()[0] : Object.class;
                }
            } else {
                valueType = Object.class;
            }
        } else {
            valueType = targetType.getGenericType();
        }
        if (upperBoundType == null) {
            upperBoundType = valueType;
        }
        if (!(upperBoundType instanceof Class)) {
            throw new ParameterResolutionException(String.format("Element %s has an unsupported type %s for annotation @%s. Service must have non-generic type.", targetType.getName(), upperBoundType.getTypeName(), this.annotation().getSimpleName()));
        }
        Class upperBoundClass = upperBoundType;
        Class<?> serviceClass = injectService.service();
        if (serviceClass.equals(this.annotation())) {
            return upperBoundClass;
        }
        if (!upperBoundClass.isAssignableFrom(serviceClass)) {
            throw new ParameterResolutionException(String.format("Element %s has service type %s for annotation @%s but field expects %s.", targetType.getName(), serviceClass.getName(), this.annotation().getSimpleName(), valueType.getTypeName()));
        }
        if (valueType instanceof WildcardType && (wild = (WildcardType)valueType).getLowerBounds().length > 0) {
            Type lowerBoundType = wild.getLowerBounds()[0];
            if (!(lowerBoundType instanceof Class)) {
                throw new ParameterResolutionException(String.format("Element %s has an unsupported lower bound %s for annotation @%s. Service must have non-generic type.", targetType.getName(), lowerBoundType.getTypeName(), this.annotation().getSimpleName()));
            }
            if (!serviceClass.isAssignableFrom((Class)lowerBoundType)) {
                throw new ParameterResolutionException(String.format("Element %s has service type %s for annotation @%s but field expects %s.", targetType.getName(), serviceClass.getName(), this.annotation().getSimpleName(), valueType.getTypeName()));
            }
        }
        return serviceClass;
    }

    @Override
    protected Object resolveValue(TargetType targetType, InjectService injectService, ExtensionContext extensionContext) throws ParameterResolutionException {
        Type serviceType = this.extractServiceType(targetType, injectService);
        ServiceConfiguration configuration = ServiceExtension.getServiceConfiguration((Class)serviceType, injectService.filter(), injectService.filterArguments(), injectService.cardinality(), injectService.timeout(), extensionContext);
        if (targetType.matches(ServiceAware.class)) {
            return configuration;
        }
        if (targetType.matches(List.class)) {
            return new ListSupplierDelegate(() -> configuration.getServices());
        }
        return configuration.getService();
    }

    public static <S> ServiceConfiguration<S> getServiceConfiguration(Class<S> serviceType, String format, String[] args, int cardinality, long timeout, ExtensionContext extensionContext) {
        ServiceConfiguration serviceConfiguration = ((CloseableServiceConfiguration)ServiceExtension.getStore(extensionContext).getOrComputeIfAbsent((Object)new ServiceConfigurationKey(serviceType, format, args, cardinality, timeout), key -> new CloseableServiceConfiguration(new ServiceConfiguration(key).init(BundleContextExtension.getBundleContext(extensionContext))), CloseableServiceConfiguration.class)).get();
        return serviceConfiguration;
    }

    static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ServiceExtension.class, extensionContext.getUniqueId()}));
    }

    public static class CloseableServiceConfiguration<S>
    implements ExtensionContext.Store.CloseableResource {
        private final ServiceConfiguration<S> serviceConfiguration;

        CloseableServiceConfiguration(ServiceConfiguration<S> serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
        }

        public void close() throws Exception {
            this.get().close();
        }

        public ServiceConfiguration<S> get() {
            return this.serviceConfiguration;
        }

        public String toString() {
            return this.get().toString();
        }
    }
}

