/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.Request;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.tools.DragEditPartTracker;
import org.eclipse.wb.gef.core.tools.Tool;

public abstract class GraphicalEditPart
extends EditPart {
    private IFigure m_figure;

    public IFigure getFigure() {
        if (this.m_figure == null) {
            this.m_figure = this.createFigure();
        }
        return this.m_figure;
    }

    public IFigure getContentPane() {
        return this.getFigure();
    }

    protected abstract IFigure createFigure();

    protected void addChildVisual(org.eclipse.gef.EditPart childPart, int index) {
        GraphicalEditPart graphicalChildPart = (GraphicalEditPart)childPart;
        if (!graphicalChildPart.addSelfVisual(index)) {
            this.getContentPane().add(graphicalChildPart.getFigure(), index);
        }
        IEditPartViewer graphicalChildViewer = graphicalChildPart.getViewer();
        IFigure graphicalChildFigure = graphicalChildPart.getFigure();
        graphicalChildViewer.getVisualPartMap().put(graphicalChildFigure, childPart);
    }

    protected boolean addSelfVisual(int index) {
        return false;
    }

    protected void removeChildVisual(org.eclipse.gef.EditPart childPart) {
        GraphicalEditPart graphicalChildPart = (GraphicalEditPart)childPart;
        if (!graphicalChildPart.removeSelfVisual()) {
            this.getContentPane().remove(graphicalChildPart.getFigure());
        }
        IEditPartViewer graphicalChildViewer = graphicalChildPart.getViewer();
        IFigure graphicalChildFigure = graphicalChildPart.getFigure();
        graphicalChildViewer.getVisualPartMap().remove(graphicalChildFigure);
    }

    protected boolean removeSelfVisual() {
        return false;
    }

    public Tool getDragTracker(Request request) {
        return new DragEditPartTracker((org.eclipse.gef.EditPart)this);
    }
}

