/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper.task;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.EObjectCollectionWrapper;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.description.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.SubVariable;
import org.eclipse.sirius.viewpoint.description.tool.AcceleoVariable;
import org.eclipse.sirius.viewpoint.description.tool.SelectModelElementVariable;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.tool.VariableContainer;

public class InitInterpreterVariablesTask
extends AbstractCommandTask {
    private final IInterpreter interpreter;
    private final Map<AbstractVariable, Object> variables;
    private final Map<AbstractVariable, String> stringVariables;
    private final UICallBack uiCallBack;

    public InitInterpreterVariablesTask(Map<AbstractVariable, Object> variables, IInterpreter interpreter, UICallBack callback) {
        this(variables, Collections.emptyMap(), interpreter, callback);
    }

    public InitInterpreterVariablesTask(Map<AbstractVariable, Object> variables, Map<AbstractVariable, String> stringVariables, IInterpreter interpreter, UICallBack callback) {
        this.variables = variables;
        this.interpreter = interpreter;
        this.stringVariables = stringVariables;
        this.uiCallBack = callback;
    }

    @Override
    public void execute() {
        this.interpreter.clearVariables();
        TreeMap<AbstractVariable, Object> sortedVariables = new TreeMap<AbstractVariable, Object>(new ModelVariableComparator());
        sortedVariables.putAll(this.variables);
        for (Map.Entry currentVariable : sortedVariables.entrySet()) {
            AbstractVariable variable = (AbstractVariable)currentVariable.getKey();
            if (variable == null) continue;
            Object value = currentVariable.getValue();
            if (value instanceof EObjectCollectionWrapper) {
                EObjectCollectionWrapper eObjectCollectionWrapper = (EObjectCollectionWrapper)value;
                this.interpreter.setVariable(variable.getName(), (Object)eObjectCollectionWrapper.getCollection());
                continue;
            }
            this.interpreter.setVariable(variable.getName(), value);
        }
        for (Map.Entry currentVariable : sortedVariables.entrySet()) {
            EObject root = this.getAnEObject(currentVariable.getValue());
            if (root == null || !(currentVariable.getKey() instanceof VariableContainer)) continue;
            VariableContainer variableContainer = (VariableContainer)currentVariable.getKey();
            for (SubVariable subVariable : variableContainer.getSubVariables()) {
                if (subVariable instanceof AcceleoVariable) {
                    AcceleoVariable acceleoVariable = (AcceleoVariable)subVariable;
                    Object result = null;
                    try {
                        result = this.interpreter.evaluate(root, acceleoVariable.getComputationExpression());
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)acceleoVariable, (EStructuralFeature)ToolPackage.eINSTANCE.getAcceleoVariable_ComputationExpression(), e);
                    }
                    this.interpreter.setVariable(acceleoVariable.getName(), result);
                    continue;
                }
                if (!(subVariable instanceof SelectModelElementVariable)) continue;
                SelectModelElementVariable selectModelElementVariable = (SelectModelElementVariable)subVariable;
                try {
                    Collection<EObject> values = this.uiCallBack.askForVariableValues(root, selectModelElementVariable);
                    if (values.size() == 1 && !selectModelElementVariable.isMultiple()) {
                        this.interpreter.setVariable(selectModelElementVariable.getName(), (Object)values.iterator().next());
                        continue;
                    }
                    if (values.size() < 1 || !selectModelElementVariable.isMultiple()) continue;
                    BasicEList eValues = new BasicEList(values);
                    this.interpreter.setVariable(selectModelElementVariable.getName(), (Object)eValues);
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException();
                }
            }
        }
        for (Map.Entry<AbstractVariable, String> currentVariable : this.stringVariables.entrySet()) {
            this.interpreter.setVariable(currentVariable.getKey().getName(), (Object)currentVariable.getValue());
        }
    }

    private EObject getAnEObject(Object value) {
        EObject result = null;
        if (value instanceof EObject) {
            result = (EObject)value;
        } else if (value instanceof Collection && ((Collection)value).size() > 0 && ((Collection)value).iterator().next() instanceof EObject) {
            result = (EObject)((Collection)value).iterator().next();
        }
        return result;
    }

    @Override
    public String getLabel() {
        return Messages.InitInterpreterVariablesTask_label;
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    private static final class ModelVariableComparator
    implements Comparator<AbstractVariable>,
    Serializable {
        private static final long serialVersionUID = -2963822840213385592L;

        private ModelVariableComparator() {
        }

        @Override
        public int compare(AbstractVariable variable0, AbstractVariable variable1) {
            if (EcoreUtil.isAncestor((EObject)variable0, (EObject)variable1) || EcoreUtil.isAncestor((EObject)variable1, (EObject)variable0)) {
                return -1;
            }
            EObject commonAncestor = ModelVariableComparator.getCommonAncestor((EObject)variable0, (EObject)variable1);
            if (commonAncestor == null) {
                throw new RuntimeException(Messages.InitInterpreterVariablesTask_invalidModelErrorMsg);
            }
            int result = 0;
            for (EObject currentObject : commonAncestor.eContents()) {
                if (currentObject == variable0 || EcoreUtil.isAncestor((EObject)currentObject, (EObject)variable0)) {
                    result = -1;
                    continue;
                }
                if (currentObject != variable1 && !EcoreUtil.isAncestor((EObject)currentObject, (EObject)variable1)) continue;
                result = 1;
            }
            return result;
        }

        private static EObject getCommonAncestor(EObject eObj1, EObject eObj2) {
            EObject commonAncestor = null;
            if (EcoreUtil.isAncestor((EObject)eObj1, (EObject)eObj2)) {
                commonAncestor = eObj1.eContainer();
            } else if (EcoreUtil.isAncestor((EObject)eObj2, (EObject)eObj1)) {
                commonAncestor = eObj2.eContainer();
            } else {
                EObject ancestor1 = eObj1.eContainer();
                while (ancestor1 != null && commonAncestor == null) {
                    EObject ancestor2 = eObj2.eContainer();
                    while (ancestor2 != null && commonAncestor == null) {
                        if (ancestor1 == ancestor2) {
                            commonAncestor = ancestor1;
                        }
                        ancestor2 = ancestor2.eContainer();
                    }
                    ancestor1 = ancestor1.eContainer();
                }
            }
            return commonAncestor;
        }
    }
}

