/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import org.eclipse.php.internal.core.util.VersionUtils;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.model.VariablesUtil;
import org.eclipse.php.internal.debug.core.zend.debugger.Debugger;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;

public class CurrentContextExpression
extends DefaultExpression {
    private static final String GET_EXTENDED_CONTEXT = "eval('if (isset($this)) { return array_merge(array(\\'this\\' => $this), get_defined_vars(), array(get_called_class())); } else { return array_merge(get_defined_vars(), array(false)); }; ');";
    private static final String GET_CONTEXT = "eval('if (isset($this)) {$this;}; return array_merge(get_defined_vars(), array(false));')";

    private CurrentContextExpression(String contextExpression) {
        super(contextExpression);
    }

    @Override
    public Expression createChildExpression(String endName, String endRepresentation, IVariableFacet.Facet ... facets) {
        if (VariablesUtil.isThis((String)(endName = "$" + (String)endName))) {
            return new DefaultExpression((String)endName, IVariableFacet.Facet.KIND_THIS);
        }
        if (VariablesUtil.isSuperGlobal((String)endName)) {
            return new DefaultExpression((String)endName, IVariableFacet.Facet.KIND_SUPER_GLOBAL);
        }
        return new DefaultExpression((String)endName, IVariableFacet.Facet.KIND_LOCAL);
    }

    public static Expression build(Debugger debugger) {
        if (CurrentContextExpression.supportsStaticContext(debugger)) {
            return new CurrentContextExpression(GET_EXTENDED_CONTEXT);
        }
        return new CurrentContextExpression(GET_CONTEXT);
    }

    public static boolean supportsStaticContext(Debugger debugger) {
        return VersionUtils.greater((String)debugger.getPHPVersion(), (String)"5.3", (int)2);
    }
}

